package io.github.xrickastley.originsgenshin.renderer.genshin;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.xrickastley.originsgenshin.data.RenderableIcon;
import io.github.xrickastley.originsgenshin.util.Rescaler;

public abstract class PowerRenderer {
	protected final class_310 client = class_310.method_1551();
	protected final class_289 tessellator = class_289.method_1348();
	protected ActiveCooldownPower power;
	protected final Rescaler rescaler;

	public PowerRenderer(Rescaler rescaler) {
		this(null, rescaler);
	}

	public PowerRenderer(ActiveCooldownPower power, Rescaler rescaler) {
		this.power = power;
		this.rescaler = rescaler;
	}

	public boolean hasPower() {
		return power != null;
	}

	/**
	 * Verifies if this skill with this {@code PowerRenderer} exists on the current client player.
	 */
	public boolean verifySkill() {
		return PowerHolderComponent.KEY.maybeGet(this.client.field_1724)
			.map(component -> component.hasPower(power.getType()))
			.orElse(false);
	}

	/**
	 * Gets the progress of the power in this {@code PowerRenderer}, or the cooldown power inside {@code RenderableIcon} if one exists.
	 * @param icon The {@code RenderableIcon} to get the progress of.
	 * @param tickDeltaManager The {@code tickDeltaManager} given in the {@code HudRenderCallback} event.
	 * @return A double representing the power or cooldown's progress, with {@code 0.0} representing none and {@code 1.0} representing full.
	 */
	public double getProgress(RenderableIcon icon, float tickDeltaManager) {
		if (icon.getCooldown() == null) return 1 - power.getProgress();

		class_3545<Integer, Integer> pair = icon.resolveCooldownResource(client.field_1724);

		if (pair.method_15442().equals(pair.method_15441())) return Math.min(Math.max(0, 1 - ((double) pair.method_15442() / pair.method_15441())), 1);

		return Math.min(Math.max(0, 1 - (((double) pair.method_15442() + tickDeltaManager) / pair.method_15441())), 1);
	}

	/**
	 * Resolves the cooldown of the provided {@code RenderableIcon} in ticks.
	 * @param icon The icon to resolve cooldown for.
	 * @return The resulting cooldown, in ticks.
	 */
	protected int resolveCooldown(RenderableIcon icon) {
		final PowerType<?> cooldownPower = icon.getCooldown();

		if (cooldownPower == null) return power.getRemainingTicks();

		class_3545<Integer, Integer> pair = icon.resolveCooldownResource(client.field_1724);

		return pair.method_15441() - pair.method_15442();
	}

	public static class_3545<Integer, Integer> resolveResource(PowerType<?> resource, class_1657 player) {
		return resolveResourceAsOptional(resource, player)
			.orElse(null);
	}


	public static Optional<class_3545<Integer, Integer>> resolveResourceAsOptional(PowerType<?> resource, class_1657 player) {
		return PowerRenderer.resolveResourceAsOptional(resource, player, false);
	}

	public static Optional<class_3545<Integer, Integer>> resolveResourceAsOptional(PowerType<?> resource, class_1657 player, boolean reverse) {
		return PowerHolderComponent.KEY.maybeGet(player)
			.map(component -> {
				final Power power = component.getPower(resource);

				class_3545<Integer, Integer> pair = null;

				if (power instanceof VariableIntPower vip) pair = new class_3545<Integer, Integer>(vip.getValue(), vip.getMax());
				else if (power instanceof CooldownPower cp) pair = new class_3545<Integer, Integer>(cp.getRemainingTicks(), cp.cooldownDuration);

				return reverse
					? pair != null
						? new class_3545<Integer, Integer>(pair.method_15441() - pair.method_15442(), pair.method_15441())
						: null
					: pair;
			});
	}

	public abstract boolean setOrPersist(ActiveCooldownPower newPower);

	/**
	 * Renders this power in the HUD.
	 * @param context The {@code DrawContext} given in the {@code HudRenderCallback} event.
	 * @param tickDeltaManager The {@code tickDeltaManager} given in the {@code HudRenderCallback} event.
	 */
	public abstract void render(class_332 context, float tickDeltaManager);

	public static int drawCenteredText(class_332 drawContext, class_327 textRenderer, class_2561 text, double x, double y, int color, boolean shadow) {
		return drawContext.method_51439(textRenderer, text, (int) (x - (textRenderer.method_27525(text) / 2)), (int) y - (textRenderer.field_2000 / 2), color, shadow);
	}

	public static class_5250 changeTextFont(class_5250 text, class_2960 font) {
		class_2583 style = text.method_10866();
		text.method_10862(style.method_27704(font));

		return text;
	}
}
