/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.originsgenshin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.registry.ModComponents;
import io.github.xrickastley.originsgenshin.interfaces.IOrigin;
import io.github.xrickastley.originsgenshin.renderer.genshin.ElementalBurstRenderer;
import io.github.xrickastley.originsgenshin.renderer.genshin.ElementalSkillRenderer;
import io.github.xrickastley.originsgenshin.util.ClientConfig;
import io.github.xrickastley.originsgenshin.util.Rescaler;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class OriginsGenshinClient
implements ClientModInitializer {
    public static final String MOD_ID = "origins-genshin";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"origins-genshin");
    private static final class_310 client = class_310.method_1551();
    private static final Rescaler RESCALER = new Rescaler(1920.0, 1080.0);
    private static final ElementalBurstRenderer ELEMENTAL_BURST_RENDERER = new ElementalBurstRenderer(RESCALER);
    private static final ElementalSkillRenderer ELEMENTAL_SKILL_RENDERER = new ElementalSkillRenderer(RESCALER);

    public void onInitializeClient() {
        LOGGER.info("Origins: Genshin (Client) Initialized!");
        HudRenderCallback.EVENT.register(this::renderSkills);
        AutoConfig.register(ClientConfig.class, GsonConfigSerializer::new);
    }

    protected void renderSkills(class_332 context, float tickDeltaManager) {
        this.renderElementalBurst(RESCALER, context, Math.max(tickDeltaManager, 0.0f));
        this.renderElementalSkill(RESCALER, context, Math.max(tickDeltaManager, 0.0f));
    }

    protected void renderElementalBurst(Rescaler rescaler, class_332 context, float tickDeltaManager) {
        for (Origin origin : ((OriginComponent)ModComponents.ORIGIN.get((Object)OriginsGenshinClient.client.field_1724)).getOrigins().values()) {
            IOrigin originMixinData = (IOrigin)origin;
            if (!originMixinData.originsgenshin$hasElementalBurstPower((class_1657)OriginsGenshinClient.client.field_1724)) continue;
            ELEMENTAL_BURST_RENDERER.setOrPersist(originMixinData.originsgenshin$getElementalBurstPower((class_1657)OriginsGenshinClient.client.field_1724));
        }
        ELEMENTAL_BURST_RENDERER.render(context, tickDeltaManager);
    }

    protected void renderElementalSkill(Rescaler rescaler, class_332 context, float tickDeltaManager) {
        for (Origin origin : ((OriginComponent)ModComponents.ORIGIN.get((Object)OriginsGenshinClient.client.field_1724)).getOrigins().values()) {
            IOrigin originMixinData = (IOrigin)origin;
            if (!originMixinData.originsgenshin$hasElementalSkillPower((class_1657)OriginsGenshinClient.client.field_1724)) continue;
            ELEMENTAL_SKILL_RENDERER.setOrPersist(originMixinData.originsgenshin$getElementalSkillPower((class_1657)OriginsGenshinClient.client.field_1724));
        }
        ELEMENTAL_SKILL_RENDERER.render(context, tickDeltaManager);
    }
}

