/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.originsgenshin.data;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.xrickastley.originsgenshin.data.RenderableSkill;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public abstract class RenderableIcon {
    protected RenderableSkill skill;
    protected final class_2960 icon;
    protected final PowerType<?> cooldown;
    protected final boolean reverse;
    protected final ConditionFactory.Instance disableCondition;
    protected final ConditionFactory.Instance condition;

    public RenderableIcon(class_2960 icon, PowerType<?> cooldown, boolean reverse, ConditionFactory.Instance condition, ConditionFactory.Instance disableCondition) {
        this.icon = icon;
        this.cooldown = cooldown;
        this.reverse = reverse;
        this.condition = condition;
        this.disableCondition = disableCondition;
    }

    public void setSkill(RenderableSkill skill) {
        this.skill = skill;
    }

    public RenderableSkill getSkill() {
        return this.skill;
    }

    public class_2960 getIcon() {
        return this.icon;
    }

    public PowerType<?> getCooldown() {
        return this.cooldown;
    }

    public boolean shouldReverseCooldown() {
        return this.reverse;
    }

    public ConditionFactory.Instance getCondition() {
        return this.condition;
    }

    public ConditionFactory.Instance getDisableCondition() {
        return this.disableCondition;
    }

    public boolean shouldRender(class_1657 entity) {
        return this.condition == null ? true : this.condition.test((Object)entity);
    }

    public boolean renderAsDisabled(class_1657 entity) {
        return this.disableCondition == null ? false : this.disableCondition.test((Object)entity);
    }

    public class_3545<Integer, Integer> resolveCooldownResource(class_1657 player) {
        ActiveCooldownPower power = this.skill.getPower();
        if (this.getCooldown() == null) {
            return new class_3545((Object)(power.cooldownDuration - power.getRemainingTicks()), (Object)power.cooldownDuration);
        }
        class_3545 pair = RenderableIcon.resolveResource(this.cooldown, player);
        return pair == null ? new class_3545((Object)(power.cooldownDuration - power.getRemainingTicks()), (Object)power.cooldownDuration) : (this.shouldReverseCooldown() ? new class_3545((Object)((Integer)pair.method_15441() - (Integer)pair.method_15442()), (Object)((Integer)pair.method_15441())) : pair);
    }

    private static class_3545<Integer, Integer> resolveResource(PowerType<?> resource, class_1657 player) {
        return PowerHolderComponent.KEY.maybeGet((Object)player).map(component -> {
            Power power = component.getPower(resource);
            class_3545 pair = null;
            if (power instanceof VariableIntPower) {
                VariableIntPower vip = (VariableIntPower)power;
                pair = new class_3545((Object)vip.getValue(), (Object)vip.getMax());
            } else if (power instanceof CooldownPower) {
                CooldownPower cp = (CooldownPower)power;
                pair = new class_3545((Object)cp.getRemainingTicks(), (Object)cp.cooldownDuration);
            }
            return pair;
        }).orElse(null);
    }
}

