/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.originsgenshin.integration;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.util.NamespaceAlias;
import io.github.xrickastley.originsgenshin.OriginsGenshin;
import io.github.xrickastley.originsgenshin.factory.OriginsGenshinFactories;
import io.github.xrickastley.originsgenshin.integration.ModIntegration;
import io.github.xrickastley.originsgenshin.power.ActionOnElementAppliedPower;
import io.github.xrickastley.originsgenshin.power.ActionOnElementEventPower;
import io.github.xrickastley.originsgenshin.power.ActionOnElementRefreshedPower;
import io.github.xrickastley.originsgenshin.power.ActionOnElementRemovedPower;
import io.github.xrickastley.originsgenshin.power.ActionOnElementalReactionPower;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.events.ElementEvents;
import io.github.xrickastley.sevenelements.events.ReactionTriggered;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;

public class SevenElementsIntegration
implements ModIntegration {
    @Override
    public void onIntegrationInitialize() {
        OriginsGenshinFactories.registerAll();
        NamespaceAlias.addAlias((String)"origins-genshin", (String)"seven-elements");
        ElementEvents.APPLIED.register((element, application) -> this.callElementEventActions(ActionOnElementAppliedPower.class, element, application));
        ElementEvents.REFRESHED.register((element, oldApp, newApp) -> this.callElementEventActions(ActionOnElementRefreshedPower.class, element, newApp));
        ElementEvents.REMOVED.register((element, application) -> this.callElementEventActions(ActionOnElementRemovedPower.class, element, application));
        ReactionTriggered.EVENT.register((reaction, reducedGauge, target, origin) -> this.callEventActions(ActionOnElementalReactionPower.class, target, power -> power.trigger(reaction, (class_1297)target, (class_1297)origin)));
    }

    private <T extends ActionOnElementEventPower> void callElementEventActions(Class<T> eventClass, Element element, @Nullable ElementalApplication application) {
        if (application == null) {
            return;
        }
        class_1309 entity = application.getEntity();
        this.callEventActions(eventClass, entity, power -> power.trigger(element, (class_1297)entity));
    }

    private <T extends Power> void callEventActions(Class<T> eventClass, class_1309 entity, Consumer<T> powerConsumer) {
        PowerHolderComponent.getPowers((class_1297)entity, eventClass).forEach(powerConsumer);
    }

    public static void requireSevenElements(Runnable runnable) {
        if (!SevenElementsIntegration.hasSevenElements()) {
            return;
        }
        try {
            runnable.run();
        }
        catch (Exception e) {
            OriginsGenshin.LOGGER.error("An unexpected exception occured while trying to run Seven Elements-only code!", (Throwable)e);
        }
    }

    public static boolean hasSevenElements() {
        FabricLoader loader = FabricLoader.getInstance();
        return loader.isModLoaded("seven-elements");
    }
}

