/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.originsgenshin.renderer.genshin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.xrickastley.originsgenshin.data.RenderableIcon;
import io.github.xrickastley.originsgenshin.util.Rescaler;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public abstract class PowerRenderer {
    protected final class_310 client = class_310.method_1551();
    protected final class_289 tessellator = class_289.method_1348();
    protected ActiveCooldownPower power;
    protected final Rescaler rescaler;

    public PowerRenderer(Rescaler rescaler) {
        this(null, rescaler);
    }

    public PowerRenderer(ActiveCooldownPower power, Rescaler rescaler) {
        this.power = power;
        this.rescaler = rescaler;
    }

    public boolean hasPower() {
        return this.power != null;
    }

    public boolean verifySkill() {
        return PowerHolderComponent.KEY.maybeGet((Object)this.client.field_1724).map(component -> component.hasPower(this.power.getType())).orElse(false);
    }

    public double getProgress(RenderableIcon icon, float tickDeltaManager) {
        if (icon.getCooldown() == null) {
            return 1.0f - this.power.getProgress();
        }
        class_3545<Integer, Integer> pair = icon.resolveCooldownResource((class_1657)this.client.field_1724);
        if (((Integer)pair.method_15442()).equals(pair.method_15441())) {
            return Math.min(Math.max(0.0, 1.0 - (double)((Integer)pair.method_15442()).intValue() / (double)((Integer)pair.method_15441()).intValue()), 1.0);
        }
        return Math.min(Math.max(0.0, 1.0 - ((double)((Integer)pair.method_15442()).intValue() + (double)tickDeltaManager) / (double)((Integer)pair.method_15441()).intValue()), 1.0);
    }

    protected int resolveCooldown(RenderableIcon icon) {
        PowerType<?> cooldownPower = icon.getCooldown();
        if (cooldownPower == null) {
            return this.power.getRemainingTicks();
        }
        class_3545<Integer, Integer> pair = icon.resolveCooldownResource((class_1657)this.client.field_1724);
        return (Integer)pair.method_15441() - (Integer)pair.method_15442();
    }

    public static class_3545<Integer, Integer> resolveResource(PowerType<?> resource, class_1657 player) {
        return PowerRenderer.resolveResourceAsOptional(resource, player).orElse(null);
    }

    public static Optional<class_3545<Integer, Integer>> resolveResourceAsOptional(PowerType<?> resource, class_1657 player) {
        return PowerRenderer.resolveResourceAsOptional(resource, player, false);
    }

    public static Optional<class_3545<Integer, Integer>> resolveResourceAsOptional(PowerType<?> resource, class_1657 player, boolean reverse) {
        return PowerHolderComponent.KEY.maybeGet((Object)player).map(component -> {
            Power power = component.getPower(resource);
            class_3545 pair = null;
            if (power instanceof VariableIntPower) {
                VariableIntPower vip = (VariableIntPower)power;
                pair = new class_3545((Object)vip.getValue(), (Object)vip.getMax());
            } else if (power instanceof CooldownPower) {
                CooldownPower cp = (CooldownPower)power;
                pair = new class_3545((Object)cp.getRemainingTicks(), (Object)cp.cooldownDuration);
            }
            return reverse ? (pair != null ? new class_3545((Object)((Integer)pair.method_15441() - (Integer)pair.method_15442()), (Object)((Integer)pair.method_15441())) : null) : pair;
        });
    }

    public abstract boolean setOrPersist(ActiveCooldownPower var1);

    public abstract void render(class_332 var1, float var2);

    public static int drawCenteredText(class_332 drawContext, class_327 textRenderer, class_2561 text, double x, double y, int color, boolean shadow) {
        int n = (int)(x - (double)(textRenderer.method_27525((class_5348)text) / 2));
        int n2 = (int)y;
        Objects.requireNonNull(textRenderer);
        return drawContext.method_51439(textRenderer, text, n, n2 - 9 / 2, color, shadow);
    }

    public static class_5250 changeTextFont(class_5250 text, class_2960 font) {
        class_2583 style = text.method_10866();
        text.method_10862(style.method_27704(font));
        return text;
    }
}

