package io.github.xrickastley.originsgenshin.condition.bientity;

import org.jetbrains.annotations.Nullable;

import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.xrickastley.originsgenshin.data.SevenElementsDataTypes;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;

public class InInternalCooldownCondition {
	private static boolean condition(SerializableData.Instance data, class_3545<class_1297, class_1297> pair) {
		final @Nullable class_1309 actor = ClassInstanceUtil.castOrNull(pair.method_15442(), class_1309.class);
		final @Nullable class_1309 target = ClassInstanceUtil.castOrNull(pair.method_15441(), class_1309.class);

		if (actor == null || target == null) return false;

		final Element element = data.get("element");
		final InternalCooldownContext icdContext = data.<InternalCooldownContext.Builder>get("internal_cooldown").build(actor);
		final ElementComponent targetComponent = ElementComponent.KEY.get(target);

		if (targetComponent == null) return false;

		return icdContext
			.getInternalCooldown(targetComponent.getElementHolder(element))
			.isInInternalCooldown();
	}

	public static ConditionFactory<class_3545<class_1297, class_1297>> getFactory() {
		return new ConditionFactory<>(
			SevenElements.identifier("in_internal_cooldown"),
			new SerializableData()
				.add("element", SevenElementsDataTypes.ELEMENT)
				.add("internal_cooldown", SevenElementsDataTypes.INTERNAL_COOLDOWN_CONTEXT_BUILDER, InternalCooldownContext.Builder.ofNone()),
			InInternalCooldownCondition::condition
		);
	}
}
