package io.github.xrickastley.originsgenshin.condition.damage;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_3545;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.xrickastley.originsgenshin.data.SevenElementsDataTypes;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;

public class ElementCondition {
	private static boolean condition(SerializableData.Instance data, class_3545<class_1282, Float> pair) {
		final List<Element> elements = data.get("elements");

		return pair.method_15442() instanceof final ElementalDamageSource eds
			? elements.contains(eds.getElementalApplication().getElement())
			: elements.contains(Element.PHYSICAL); // Non-elemental Damage Sources are considered PHYSICAL.
	}

	public static ConditionFactory<class_3545<class_1282, Float>> getFactory() {
		return new ConditionFactory<>(
			SevenElements.identifier("element"),
			new SerializableData()
				.add("elements", SevenElementsDataTypes.ELEMENTS),
			ElementCondition::condition
		);
	}
}
