package io.github.xrickastley.originsgenshin.data;

import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import net.minecraft.class_1297;
import net.minecraft.class_2960;

public class ElementalSkillIcon extends RenderableIcon {
	protected final int charges;
	protected final ChargeRender chargeRender;

	public ElementalSkillIcon(class_2960 icon, PowerType<?> cooldown, boolean reverse, int charges, ChargeRender chargeRender, ConditionFactory<class_1297>.Instance condition, ConditionFactory<class_1297>.Instance disableCondition) {
		super(icon, cooldown, reverse, condition, disableCondition);

		this.charges = Math.min(Math.max(1, charges), 3);
		this.chargeRender = chargeRender;
		this.chargeRender.setElementalSkillIcon(this);
	}

	public int getCharges() {
		return Math.min(3, Math.max(charges, 1));
	}

	public ChargeRender getChargeRender() {
		return chargeRender;
	}

	@Override
	public ElementalSkill getSkill() {
		return ((ElementalSkill) super.getSkill());
	}
}
