package io.github.xrickastley.originsgenshin.data;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3545;

public abstract class RenderableIcon {
	protected RenderableSkill skill;
	protected final class_2960 icon;
	protected final PowerType<?> cooldown;
	protected final boolean reverse;
	protected final ConditionFactory<class_1297>.Instance disableCondition;
	protected final ConditionFactory<class_1297>.Instance condition;

	public RenderableIcon(class_2960 icon, PowerType<?> cooldown, boolean reverse, ConditionFactory<class_1297>.Instance condition, ConditionFactory<class_1297>.Instance disableCondition) {
		this.icon = icon;
		this.cooldown = cooldown;
		this.reverse = reverse;
		this.condition = condition;
		this.disableCondition = disableCondition;
	}

	public void setSkill(RenderableSkill skill) {
		this.skill = skill;
	}

	public RenderableSkill getSkill() {
		return skill;
	}

	public class_2960 getIcon() {
		return icon;
	}

	public PowerType<?> getCooldown() {
		return cooldown;
	}

	public boolean shouldReverseCooldown() {
		return reverse;
	}

	public ConditionFactory<class_1297>.Instance getCondition() {
		return condition;
	}

	public ConditionFactory<class_1297>.Instance getDisableCondition() {
		return disableCondition;
	}

	public boolean shouldRender(class_1657 entity) {
		return this.condition == null
			? true
			: this.condition.test(entity);
	}

	public boolean renderAsDisabled(class_1657 entity) {
		return this.disableCondition == null
			? false
			: this.disableCondition.test(entity);
	}

	/**
	 * Resolves the cooldown resource. The output will always be a {@code Pair<Integer, Integer>} with the {@code left} rising until the {@code right}.
	 * @param player The player to resolvle the cooldown resource for.
	 * @return A resolved {@code Pair<Integer, Integer>} with the {@code left} rising until the {@code right}.
	 */
	public class_3545<Integer, Integer> resolveCooldownResource(class_1657 player) {
		final ActiveCooldownPower power = this.skill.getPower();

		if (this.getCooldown() == null) return new class_3545<Integer,Integer>(power.cooldownDuration - power.getRemainingTicks(), power.cooldownDuration);

		class_3545<Integer, Integer> pair = RenderableIcon.resolveResource(this.cooldown, player);

		return pair == null
			? new class_3545<Integer,Integer>(power.cooldownDuration - power.getRemainingTicks(), power.cooldownDuration)
			: this.shouldReverseCooldown()
				? new class_3545<Integer,Integer>(pair.method_15441() - pair.method_15442(), pair.method_15441())
				: pair;
	}

	private static class_3545<Integer, Integer> resolveResource(PowerType<?> resource, class_1657 player) {
		return PowerHolderComponent.KEY.maybeGet(player)
			.map(component -> {
				final Power power = component.getPower(resource);

				class_3545<Integer, Integer> pair = null;

				if (power instanceof VariableIntPower vip) pair = new class_3545<Integer, Integer>(vip.getValue(), vip.getMax());
				else if (power instanceof CooldownPower cp) pair = new class_3545<Integer, Integer>(cp.getRemainingTicks(), cp.cooldownDuration);

				return pair;
			})
			.orElse(null);
	}
}
