package io.github.xrickastley.originsgenshin.power;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.xrickastley.originsgenshin.data.SevenElementsDataTypes;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.Element;

public final class ActionOnElementAppliedPower extends ActionOnElementEventPower {
	private ActionOnElementAppliedPower(PowerType<?> type, class_1309 entity, List<Element> elements, Consumer<class_1297> entityAction) {
		super(type, entity, elements, entityAction);
	}

    public static PowerFactory<?> createFactory() {
        return new PowerFactory<>(
            SevenElements.identifier("action_on_element_applied"),
            new SerializableData()
				.add("elements", SevenElementsDataTypes.ELEMENTS)
                .add("entity_action", ApoliDataTypes.ENTITY_ACTION),
            data -> (powerType, livingEntity) -> new ActionOnElementAppliedPower(
                powerType,
                livingEntity,
                data.get("elements"),
                data.get("entity_action")
            )
        ).allowCondition();
    }
}
