/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.originsgenshin.data;

import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.xrickastley.originsgenshin.data.RenderableIcon;
import java.util.List;
import net.minecraft.class_1657;

public abstract class RenderableSkill {
    protected ActiveCooldownPower power;
    protected final boolean showCooldown;
    protected final boolean shouldRender;
    protected final List<RenderableIcon> icons;
    protected final ConditionFactory.Instance disable;

    public RenderableSkill(boolean showCooldown, boolean shouldRender, ConditionFactory.Instance disableCondition, List<RenderableIcon> iconConditions) {
        this.showCooldown = showCooldown;
        this.shouldRender = shouldRender;
        this.icons = iconConditions;
        this.disable = disableCondition;
        if (this.icons != null) {
            this.icons.forEach(icon -> icon.setSkill(this));
        }
    }

    public RenderableSkill setPower(ActiveCooldownPower power) {
        this.power = power;
        return this;
    }

    public ActiveCooldownPower getPower() {
        return this.power;
    }

    public boolean shouldShowCooldown() {
        return this.showCooldown;
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    public ConditionFactory.Instance getDisableCondition() {
        return this.disable;
    }

    public List<RenderableIcon> getIcons() {
        return this.icons;
    }

    public RenderableIcon getRenderedIcon(class_1657 entity) {
        if (!this.shouldRender() || this.icons == null) {
            return null;
        }
        for (RenderableIcon icon : this.icons) {
            if (!icon.shouldRender(entity)) continue;
            return icon;
        }
        return null;
    }

    public boolean isDisabled(class_1657 entity) {
        return this.disable == null ? false : this.disable.test((Object)entity);
    }
}

