/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.originsgenshin.power;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsgenshin.data.SevenElementsDataTypes;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

public class ActionOnElementalReactionPower
extends Power {
    private final Set<ElementalReaction> reactions;
    @Nullable
    private final Consumer<class_1297> entityAction;
    @Nullable
    private final Consumer<class_3545<class_1297, class_1297>> bientityAction;
    private final boolean alwaysTrigger;

    protected ActionOnElementalReactionPower(PowerType<?> type, class_1309 entity, List<ElementalReaction> reactions, Consumer<class_1297> entityAction, Consumer<class_3545<class_1297, class_1297>> bientityAction, boolean alwaysTrigger) {
        super(type, entity);
        this.reactions = new HashSet<ElementalReaction>(reactions);
        this.entityAction = entityAction;
        this.bientityAction = bientityAction;
        this.alwaysTrigger = alwaysTrigger;
    }

    public void trigger(ElementalReaction reaction, class_1297 target, @Nullable class_1297 origin) {
        if (target != this.entity || !this.reactions.isEmpty() || !this.reactions.contains(reaction)) {
            return;
        }
        if (origin != null && this.entityAction != null && this.alwaysTrigger) {
            this.entityAction.accept(target);
        }
        if (origin == null && this.entityAction != null) {
            this.entityAction.accept(target);
        } else if (this.bientityAction != null) {
            this.bientityAction.accept((class_3545<class_1297, class_1297>)new class_3545((Object)origin, (Object)target));
        }
    }

    public static PowerFactory<?> createFactory() {
        return new PowerFactory(SevenElements.identifier((String)"action_on_elemental_reaction"), new SerializableData().add("reactions", SevenElementsDataTypes.ELEMENTAL_REACTIONS).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.ENTITY_ACTION, null).add("always_trigger", SerializableDataTypes.BOOLEAN, (Object)false), data -> (powerType, livingEntity) -> new ActionOnElementalReactionPower((PowerType<?>)powerType, (class_1309)livingEntity, (List)data.get("reactions"), (Consumer)data.get("entity_action"), (Consumer)data.get("bientity_action"), data.getBoolean("always_trigger"))).allowCondition();
    }
}

