/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.originsgenshin.renderer.genshin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.xrickastley.originsgenshin.OriginsGenshin;
import io.github.xrickastley.originsgenshin.data.ElementalBurst;
import io.github.xrickastley.originsgenshin.data.ElementalBurstIcon;
import io.github.xrickastley.originsgenshin.interfaces.IActiveCooldownPower;
import io.github.xrickastley.originsgenshin.renderer.genshin.PowerRenderer;
import io.github.xrickastley.originsgenshin.util.CircleRenderer;
import io.github.xrickastley.originsgenshin.util.ClientConfig;
import io.github.xrickastley.originsgenshin.util.Rescaler;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ElementalBurstRenderer
extends PowerRenderer {
    public ElementalBurstRenderer(Rescaler rescaler) {
        this(null, rescaler);
    }

    public ElementalBurstRenderer(ActiveCooldownPower power, Rescaler rescaler) {
        super(power, rescaler);
    }

    @Override
    public boolean setOrPersist(ActiveCooldownPower newPower) {
        if (newPower == null || !((IActiveCooldownPower)newPower).originsgenshin$hasElementalBurst()) {
            return false;
        }
        this.power = newPower;
        return true;
    }

    @Override
    public void render(class_332 drawContext, float tickDeltaManager) {
        ClientConfig config = (ClientConfig)AutoConfig.getConfigHolder(ClientConfig.class).getConfig();
        if (!config.renderers.showElementalBurst || this.power == null) {
            return;
        }
        if (!this.verifySkill()) {
            this.power = null;
            return;
        }
        try {
            ElementalBurst elementalBurstData = ((IActiveCooldownPower)this.power).originsgenshin$getElementalBurst();
            ElementalBurstIcon burstIcon = elementalBurstData.getRenderedIcon((class_1657)this.client.field_1724);
            if (elementalBurstData == null || !elementalBurstData.shouldRender() || burstIcon == null) {
                return;
            }
            class_4587 matrices = drawContext.method_51448();
            CircleRenderer circleRenderer = new CircleRenderer(0.0, 0.0, 0.0);
            double percentFilled = this.getProgress(burstIcon, tickDeltaManager);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
            matrices.method_22903();
            matrices.method_46416((float)this.rescaler.rescaleX(1820.0), (float)this.rescaler.rescaleY(972.0), 0.0f);
            matrices.method_22905(1.0f, 1.0f, 1.0f);
            Matrix4f posMatrix = matrices.method_23760().method_23761();
            this.renderFill(burstIcon, circleRenderer, drawContext, posMatrix);
            this.renderIcon(elementalBurstData, burstIcon, circleRenderer, drawContext, posMatrix, this.rescaler, percentFilled);
            this.renderCooldown(elementalBurstData, burstIcon, drawContext, this.rescaler, percentFilled);
            matrices.method_22909();
        }
        catch (Exception e) {
            OriginsGenshin.sublogger(ElementalBurstRenderer.class).error("An error occured while trying to render Elemental Burst", (Throwable)e);
        }
    }

    private void renderFill(ElementalBurstIcon icon, CircleRenderer circleRenderer, class_332 drawContext, Matrix4f posMatrix) {
        double radiusEB = 56.0 * this.rescaler.getRescaleFactorWindow();
        circleRenderer.add(radiusEB, 1.0, 0x64646464).draw(posMatrix);
        if (icon.getColor() == null) {
            return;
        }
        double resourceMultiplier = this.resolveFillResource(icon);
        if (resourceMultiplier == -1.0) {
            return;
        }
        drawContext.method_44379(this.rescaler.rescaleX(1762.0), this.rescaler.rescaleY(1030.0 - 114.0 * resourceMultiplier), this.rescaler.rescaleX(1876.0), this.rescaler.rescaleY(1030.0));
        circleRenderer.add(radiusEB, 1.0, icon.getColor().asARGB());
        if (resourceMultiplier == 1.0 && icon.getOutlineColor() != null) {
            double innerRadiusEB = 50.0 * this.rescaler.getRescaleFactorWindow();
            double outerRadiusEB = 6.0 * this.rescaler.getRescaleFactorWindow();
            circleRenderer.addOutline(innerRadiusEB, outerRadiusEB, 1.0, icon.getOutlineColor().asARGB());
        }
        circleRenderer.draw(posMatrix);
        drawContext.method_44380();
    }

    private void renderIcon(ElementalBurst burstData, ElementalBurstIcon icon, CircleRenderer circleRenderer, class_332 drawContext, Matrix4f posMatrix, Rescaler rescaler, double percentFilled) {
        boolean disable;
        int scaleEB = (int)(112.0 * rescaler.getRescaleFactor());
        boolean bl = disable = percentFilled > 0.0 || burstData.isDisabled((class_1657)this.client.field_1724) || icon.renderAsDisabled((class_1657)this.client.field_1724);
        if (disable) {
            this.renderExtraFill(icon, percentFilled, circleRenderer, drawContext, posMatrix);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.375f);
        }
        drawContext.method_25290(icon.getIcon(), -scaleEB / 2, -scaleEB / 2, 0.0f, 0.0f, scaleEB, scaleEB, scaleEB, scaleEB);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        circleRenderer.add(56.0 * rescaler.getRescaleFactorWindow(), percentFilled, 650692808).addOutline(50.0 * rescaler.getRescaleFactorWindow(), 6.0 * rescaler.getRescaleFactorWindow(), percentFilled, -1714894648).draw(posMatrix);
    }

    private void renderCooldown(ElementalBurst burstData, ElementalBurstIcon icon, class_332 drawContext, Rescaler rescaler, double percentFilled) {
        if (percentFilled == 0.0 || !burstData.shouldShowCooldown()) {
            return;
        }
        class_4587 matrices = drawContext.method_51448();
        float scale = (float)(1.35 * rescaler.getRescaleFactorWindow());
        matrices.method_22903();
        matrices.method_22905(scale, scale, 1.0f);
        PowerRenderer.drawCenteredText(drawContext, this.client.field_1772, (class_2561)PowerRenderer.changeTextFont(class_2561.method_43470((String)String.format("%.1f", (double)this.resolveCooldown(icon) / 20.0)), OriginsGenshin.identifier("genshin")), 0.0, 0.0, -1, false);
        matrices.method_22909();
    }

    private void renderExtraFill(ElementalBurstIcon icon, double percentFilled, CircleRenderer circleRenderer, class_332 drawContext, Matrix4f posMatrix) {
        if (icon.getColor() == null) {
            return;
        }
        double resourceMultiplier = this.resolveFillResource(icon);
        if (resourceMultiplier != 1.0) {
            return;
        }
        circleRenderer.add(56.0 * this.rescaler.getRescaleFactorWindow(), 1.0, icon.getColor().from().multiply(1.0, 1.0, 1.0, 0.5).asARGB());
        if (icon.getOutlineColor() != null) {
            double innerRadiusEB = 50.0 * this.rescaler.getRescaleFactorWindow();
            double outerRadiusEB = 6.0 * this.rescaler.getRescaleFactorWindow();
            circleRenderer.addOutline(innerRadiusEB, outerRadiusEB, 1.0, icon.getOutlineColor().from().multiply(1.25, 1.25, 1.25, 0.5).asARGB()).addOutline(innerRadiusEB, outerRadiusEB, percentFilled, icon.getOutlineColor().from().multiply(1.5, 1.5, 1.5, 0.5).asARGB());
        }
        circleRenderer.draw(posMatrix);
    }

    public double resolveFillResource(ElementalBurstIcon skillIcon) {
        if (skillIcon.getResource() == null) {
            return -1.0;
        }
        return PowerRenderer.resolveResourceAsOptional(skillIcon.getResource(), (class_1657)this.client.field_1724).map(pair -> Math.min(1.0, Math.max((double)((Integer)pair.method_15442()).intValue() / (double)(skillIcon.getNewMax() != -1 ? skillIcon.getNewMax() : ((Integer)pair.method_15441()).intValue()), 0.0))).orElse(-1.0);
    }
}

