/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.originsgenshin.renderer.genshin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.xrickastley.originsgenshin.OriginsGenshin;
import io.github.xrickastley.originsgenshin.data.ChargeRender;
import io.github.xrickastley.originsgenshin.data.ElementalSkill;
import io.github.xrickastley.originsgenshin.data.ElementalSkillIcon;
import io.github.xrickastley.originsgenshin.interfaces.IActiveCooldownPower;
import io.github.xrickastley.originsgenshin.renderer.genshin.PowerRenderer;
import io.github.xrickastley.originsgenshin.util.CircleRenderer;
import io.github.xrickastley.originsgenshin.util.ClientConfig;
import io.github.xrickastley.originsgenshin.util.Rescaler;
import java.util.ArrayList;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ElementalSkillRenderer
extends PowerRenderer {
    public ElementalSkillRenderer(Rescaler rescaler) {
        this(null, rescaler);
    }

    public ElementalSkillRenderer(ActiveCooldownPower power, Rescaler rescaler) {
        super(power, rescaler);
    }

    protected int resolveCooldown(ElementalSkillIcon icon) {
        PowerType<?> cooldownPower = icon.getCooldown();
        if (cooldownPower == null) {
            return this.power.getRemainingTicks();
        }
        class_3545<Integer, Integer> pair = icon.resolveCooldownResource((class_1657)this.client.field_1724);
        if (((Integer)pair.method_15442()).equals(pair.method_15441())) {
            return 0;
        }
        int newMax = (int)Math.round((double)((Integer)pair.method_15441()).intValue() / (double)icon.getCharges());
        return newMax - (Integer)pair.method_15442() % newMax;
    }

    @Override
    public boolean setOrPersist(ActiveCooldownPower newPower) {
        if (newPower == null || !((IActiveCooldownPower)newPower).originsgenshin$hasElementalSkill()) {
            return false;
        }
        this.power = newPower;
        return true;
    }

    @Override
    public void render(class_332 drawContext, float tickDeltaManager) {
        ClientConfig config = (ClientConfig)AutoConfig.getConfigHolder(ClientConfig.class).getConfig();
        if (!config.renderers.showElementalSkill || this.power == null) {
            return;
        }
        if (!this.verifySkill()) {
            this.power = null;
            return;
        }
        try {
            ElementalSkill elementalSkillData = ((IActiveCooldownPower)this.power).originsgenshin$getElementalSkill();
            ElementalSkillIcon skillIcon = elementalSkillData.getRenderedIcon((class_1657)this.client.field_1724);
            if (elementalSkillData == null || !elementalSkillData.shouldRender() || skillIcon == null) {
                return;
            }
            class_4587 matrices = drawContext.method_51448();
            CircleRenderer circleRenderer = new CircleRenderer(0.0, 0.0, 0.0);
            double percentFilled = this.resolvePercentFilled(skillIcon, tickDeltaManager);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
            matrices.method_22903();
            matrices.method_46416((float)this.rescaler.rescaleX(1700.0), (float)this.rescaler.rescaleY(992.0), 0.0f);
            matrices.method_22905(1.0f, 1.0f, 1.0f);
            Matrix4f posMatrix = matrices.method_23760().method_23761();
            this.renderIcon(skillIcon, circleRenderer, drawContext, posMatrix, this.rescaler, percentFilled);
            this.renderCharges(skillIcon, circleRenderer, drawContext, tickDeltaManager, posMatrix);
            this.renderCooldown(elementalSkillData, skillIcon, drawContext, percentFilled);
            matrices.method_22909();
        }
        catch (Exception e) {
            OriginsGenshin.sublogger(ElementalSkillRenderer.class).error("An error occured while trying to render Elemental Skill", (Throwable)e);
        }
    }

    private double resolvePercentFilled(ElementalSkillIcon skillIcon, float tickDeltaManager) {
        class_3545<Integer, Integer> pair = skillIcon.resolveCooldownResource((class_1657)this.client.field_1724);
        double newMaximum = (Integer)pair.method_15441() / skillIcon.getCharges();
        if ((double)((Integer)pair.method_15442()).intValue() % newMaximum == 0.0 && (Integer)pair.method_15442() > 0) {
            return 0.0;
        }
        return Math.min(Math.max(0.0, 1.0 - ((double)((Integer)pair.method_15442()).intValue() % newMaximum + (double)tickDeltaManager) / newMaximum), 1.0);
    }

    private void renderIcon(ElementalSkillIcon icon, CircleRenderer circleRenderer, class_332 drawContext, Matrix4f posMatrix, Rescaler rescaler, double percentFilled) {
        int scaleES = (int)(76.0 * rescaler.getRescaleFactor());
        boolean disable = percentFilled > 0.0 && icon.getChargeRender().getCurrentCharges((class_1657)this.client.field_1724) == 0 || icon.getSkill().isDisabled((class_1657)this.client.field_1724) || icon.renderAsDisabled((class_1657)this.client.field_1724);
        circleRenderer.add(36.0 * rescaler.getRescaleFactorWindow(), 1.0, 0x64646464).draw(posMatrix);
        if (disable) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.375f);
        }
        drawContext.method_25290(icon.getIcon(), -scaleES / 2, -scaleES / 2, 0.0f, 0.0f, scaleES, scaleES, scaleES, scaleES);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderCharges(ElementalSkillIcon skillIcon, CircleRenderer circleRenderer, class_332 drawContext, float tickDeltaManager, Matrix4f posMatrix) {
        boolean disable;
        ChargeRender chargeRender = skillIcon.getChargeRender();
        double percentFilled = this.resolvePercentFilled(skillIcon, tickDeltaManager);
        boolean bl = disable = percentFilled > 0.0 || skillIcon.getSkill().isDisabled((class_1657)this.client.field_1724) || skillIcon.renderAsDisabled((class_1657)this.client.field_1724);
        if (skillIcon.getChargeRender() == null || skillIcon.getCharges() == 1) {
            circleRenderer.add(36.0 * this.rescaler.getRescaleFactorWindow(), percentFilled, 0xDC8C8C8).addOutline(32.0 * this.rescaler.getRescaleFactorWindow(), 4.0 * this.rescaler.getRescaleFactorWindow(), (double)disable, 449366216).addOutline(32.0 * this.rescaler.getRescaleFactorWindow(), 4.0 * this.rescaler.getRescaleFactorWindow(), percentFilled, -2134325048).draw(posMatrix);
        } else {
            int charges = skillIcon.getCharges();
            int currentCharges = chargeRender.getCurrentCharges((class_1657)this.client.field_1724);
            if (currentCharges == 0) {
                circleRenderer.add(36.0 * this.rescaler.getRescaleFactorWindow(), percentFilled, 0xDC8C8C8).addOutline(32.0 * this.rescaler.getRescaleFactorWindow(), 4.0 * this.rescaler.getRescaleFactorWindow(), (double)disable, 449366216).addOutline(32.0 * this.rescaler.getRescaleFactorWindow(), 4.0 * this.rescaler.getRescaleFactorWindow(), percentFilled, -2134325048);
            }
            if (charges > currentCharges) {
                circleRenderer.addOutline(32.0 * this.rescaler.getRescaleFactorWindow(), 4.0 * this.rescaler.getRescaleFactorWindow(), percentFilled, -1714894648);
            }
            circleRenderer.draw(posMatrix);
            int scaleCharge = (int)(12.0 * this.rescaler.getRescaleFactor());
            ArrayList<class_3545<Double, Double>> positions = this.generateChargesWithCenter(0, (int)(-44.0 * this.rescaler.getRescaleFactor()), scaleCharge, scaleCharge, (int)(4.0 * this.rescaler.getRescaleFactor()), charges);
            for (int i = 0; i < positions.size(); ++i) {
                class_3545<Double, Double> pos = positions.get(i);
                class_2960 chargeTexture = i < currentCharges ? OriginsGenshin.identifier("textures/skill/charge.png") : OriginsGenshin.identifier("textures/skill/charge_empty.png");
                drawContext.method_25290(chargeTexture, ((Double)pos.method_15442()).intValue(), ((Double)pos.method_15441()).intValue(), 0.0f, 0.0f, scaleCharge, scaleCharge, scaleCharge, scaleCharge);
            }
        }
    }

    private void renderCooldown(ElementalSkill skillData, ElementalSkillIcon skillIcon, class_332 drawContext, double percentFilled) {
        if (skillIcon.getChargeRender().getMethod() == ChargeRender.Method.CONDITIONAL || !skillData.shouldShowCooldown() || percentFilled == 0.0) {
            return;
        }
        class_4587 matrices = drawContext.method_51448();
        float scale = (float)(1.0 * this.rescaler.getRescaleFactorWindow());
        matrices.method_22903();
        matrices.method_22905(scale, scale, 1.0f);
        PowerRenderer.drawCenteredText(drawContext, this.client.field_1772, (class_2561)PowerRenderer.changeTextFont(class_2561.method_43470((String)String.format("%.1f", (double)this.resolveCooldown(skillIcon) / 20.0)), OriginsGenshin.identifier("genshin")), 0.0, 0.0, -1, false);
        matrices.method_22909();
    }

    private ArrayList<class_3545<Double, Double>> generateChargesWithCenter(int x, int y, int w, int l, int s, int n) {
        ArrayList<class_3545<Double, Double>> positions = new ArrayList<class_3545<Double, Double>>();
        double totalSpacing = (-Math.abs(n - 2) + 4) * (n - 1) / 2;
        double totalWidth = (double)(w * n) + totalSpacing;
        double offset = totalWidth / 2.0;
        double highestYOffset = (double)s * Math.abs(Math.min(Math.floor(n / 2), (double)n - (Math.floor(n / 2) + 1.0)) - (Math.ceil(n / 2) - 1.0));
        for (int i = 0; i < n; ++i) {
            double j = Math.ceil(n / 2) - 1.0;
            double yOffset = (double)s * Math.abs((double)Math.min(i, n - (i + 1)) - j);
            double spacing = (double)i * (totalSpacing / (double)(n - 1));
            class_3545 pair = new class_3545((Object)((double)x - offset + (spacing + (double)(i * w))), (Object)((double)y + (highestYOffset - yOffset)));
            positions.add((class_3545<Double, Double>)pair);
        }
        return positions;
    }
}

