/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes;

import dev.silal.soulnotes.Scheduler;
import dev.silal.soulnotes.commands.notes.DeleteNoteCommand;
import dev.silal.soulnotes.commands.notes.LikeNoteCommand;
import dev.silal.soulnotes.commands.notes.NoteCommand;
import dev.silal.soulnotes.commands.notes.tab.DeleteTabCompleter;
import dev.silal.soulnotes.config.Configuration;
import dev.silal.soulnotes.config.database.Database;
import dev.silal.soulnotes.config.database.MySQLDatabase;
import dev.silal.soulnotes.config.database.SQLiteDatabase;
import dev.silal.soulnotes.config.database.util.DatabaseUtil;
import dev.silal.soulnotes.listeners.player.PlayerInteractEntityListener;
import dev.silal.soulnotes.listeners.player.PlayerInteractListener;
import dev.silal.soulnotes.notes.NoteManager;
import dev.silal.soulnotes.notes.spawner.NoteSpawner;
import dev.silal.soulnotes.placeholder.SoulNotesPlaceholder;
import dev.silal.soulnotes.protektion.ProtectionManager;
import dev.silal.soulnotes.utils.JsonManager;
import dev.silal.soulnotes.utils.Metrics;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class SoulNotes
extends JavaPlugin {
    private static SoulNotes instance;
    private Configuration configuration;
    private Database database;
    private NoteSpawner noteSpawner;
    private NoteManager noteManager;
    private ProtectionManager protectionManager;
    private Metrics metrics;

    public static SoulNotes getInstance() {
        return instance;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Database getDatabase() {
        return this.database;
    }

    public NoteSpawner getNoteSpawner() {
        return this.noteSpawner;
    }

    public NoteManager getNoteManager() {
        return this.noteManager;
    }

    public ProtectionManager getProtectionManager() {
        return this.protectionManager;
    }

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.getLogger().info("Starting SoulNotes...");
        this.configuration = new Configuration(this);
        this.connectDatabase();
        this.noteSpawner = new NoteSpawner(this);
        this.noteManager = new NoteManager(this);
        this.getLogger().info("Creating all Notes...");
        this.noteSpawner.removeAllNotes();
        this.noteSpawner.spawnAllNotes();
        this.protectionManager = new ProtectionManager(this);
        this.metrics = new Metrics((Plugin)this, 26445);
        this.metrics.addCustomChart(new Metrics.SingleLineChart("average_notes", () -> {
            try {
                return Math.toIntExact(DatabaseUtil.countEntries("notes", null, this.database.getStatement()));
            }
            catch (Exception exception) {
                return 0;
            }
        }));
        this.initListener();
        this.initCommands();
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new SoulNotesPlaceholder(this).register();
        }
        Scheduler.start();
        this.getLogger().info("Checking for updates...");
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String line;
                String apiUrl = "https://api.github.com/repos/Silal123/SoulNotes/releases/latest";
                HttpURLConnection connection = (HttpURLConnection)new URL(apiUrl).openConnection();
                connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder json = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    json.append(line);
                }
                JsonManager release = new JsonManager(json.toString());
                String latestVersion = release.getString("tag_name").replace("v", "");
                String currentVersion = this.getDescription().getVersion();
                if (!currentVersion.equalsIgnoreCase(latestVersion)) {
                    this.getLogger().warning("There is a new version available: " + latestVersion);
                    this.getLogger().warning("You are using: " + currentVersion);
                } else {
                    this.getLogger().info("Your plugin is up to date!");
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Error while checking for updates: " + e.getMessage());
            }
        });
    }

    private void initListener() {
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)new PlayerInteractEntityListener(), (Plugin)this);
        manager.registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
    }

    private void initCommands() {
        this.getCommand("soulnote").setExecutor((CommandExecutor)new NoteCommand());
        this.getCommand("deletesoulnote").setExecutor((CommandExecutor)new DeleteNoteCommand());
        this.getCommand("deletesoulnote").setTabCompleter((TabCompleter)new DeleteTabCompleter());
        this.getCommand("likesoulnote").setExecutor((CommandExecutor)new LikeNoteCommand());
    }

    private void connectDatabase() {
        String type = this.configuration.getDatabaseType();
        if (type.equalsIgnoreCase("mysql")) {
            this.database = new MySQLDatabase(this.configuration.getMysqlHost(), this.configuration.getMysqlPort(), this.configuration.getMysqlDatabase(), this.configuration.getMysqlUsername(), this.configuration.getMysqlPassword());
        } else if (type.equalsIgnoreCase("sqlite")) {
            File file = new File(this.getDataFolder(), this.configuration.getSqliteDatabaseFile());
            this.database = new SQLiteDatabase(file);
        } else {
            this.getLogger().severe("Database type " + type + " not found!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.database.connect();
            this.database.setup();
            this.getLogger().info("Database connected successfully: " + type.toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().severe("Failed to connect to database");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.database.disconnect();
        Scheduler.stop();
    }
}

