/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.config;

import dev.silal.soulnotes.SoulNotes;
import dev.silal.soulnotes.utils.config.ConfigValue;
import dev.silal.soulnotes.utils.config.ListConfigValue;
import java.io.File;
import java.util.List;

public class Configuration
extends dev.silal.soulnotes.utils.config.Configuration {
    private final SoulNotes plugin;
    private final ConfigValue<String> databaseType = new ConfigValue<String>("database.type", String.class, this, "sqlite");
    private final ConfigValue<String> sqliteDatabaseFile = new ConfigValue<String>("database.sqlite.file", String.class, this, "database.db");
    private final ConfigValue<String> mysqlHost = new ConfigValue<String>("database.mysql.host", String.class, this, "127.0.0.1");
    private final ConfigValue<Integer> mysqlPort = new ConfigValue<Integer>("database.mysql.port", Integer.class, this, 3306);
    private final ConfigValue<String> mysqlDatabase = new ConfigValue<String>("database.mysql.database", String.class, this, "soulnotes");
    private final ConfigValue<String> mysqlUsername = new ConfigValue<String>("database.mysql.user", String.class, this, "user");
    private final ConfigValue<String> mysqlPassword = new ConfigValue<String>("database.mysql.password", String.class, this, "password");
    private final ConfigValue<Integer> minNoteDistance = new ConfigValue<Integer>("note.distance", Integer.class, this, 5);
    private final ConfigValue<Integer> playerNotesMax = new ConfigValue<Integer>("notes.player.max", Integer.class, this, 50);
    private final ConfigValue<Boolean> needsPermissionToCreate = new ConfigValue<Boolean>("notes.create.permission", Boolean.class, this, false);
    private final ConfigValue<Boolean> noteTitleEnabled = new ConfigValue<Boolean>("notes.hologram.title.enabled", Boolean.class, this, true);
    private final ConfigValue<Boolean> noteFooterEnabled = new ConfigValue<Boolean>("notes.hologram.footer.enabled", Boolean.class, this, true);
    private final ConfigValue<String> noteFooterType = new ConfigValue<String>("notes.hologram.footer.type", String.class, this, "likes");
    private final ListConfigValue<String> blackListedWorlds = new ListConfigValue<String>("notes.worlds.blacklist", String.class, this, List.of("no_notes"));
    private final ConfigValue<Boolean> spawnProtectionEnabled = new ConfigValue<Boolean>("protection.spawn.enabled", Boolean.class, this, true);
    private final ConfigValue<Integer> spawnProtection = new ConfigValue<Integer>("protection.spawn.radius", Integer.class, this, 16);
    private final ConfigValue<Boolean> worldGuardProtectionEnabled = new ConfigValue<Boolean>("protection.worldguard", Boolean.class, this, true);

    public Configuration(SoulNotes plugin) {
        super(plugin.getDataFolder().getPath() + File.separator + "config.yml");
        this.plugin = plugin;
    }

    public String getDatabaseType() {
        return this.databaseType.get();
    }

    public String getSqliteDatabaseFile() {
        return this.sqliteDatabaseFile.get();
    }

    public String getMysqlHost() {
        return this.mysqlHost.get();
    }

    public int getMysqlPort() {
        return this.mysqlPort.get();
    }

    public String getMysqlDatabase() {
        return this.mysqlDatabase.get();
    }

    public String getMysqlUsername() {
        return this.mysqlUsername.get();
    }

    public String getMysqlPassword() {
        return this.mysqlPassword.get();
    }

    public int getMinNoteDistance() {
        return this.minNoteDistance.get();
    }

    public int getPlayerMaxNotes() {
        return this.playerNotesMax.get();
    }

    public boolean getNeedsPermissionToCreate() {
        return this.needsPermissionToCreate.get();
    }

    public List<String> getBlacklistedWorlds() {
        return this.blackListedWorlds.get();
    }

    public boolean getSpawnProtectionEnabled() {
        return this.spawnProtectionEnabled.get();
    }

    public int getSpawnProtectionRadius() {
        return this.spawnProtection.get();
    }

    public boolean getWorldGuardProtectionEnabled() {
        return this.worldGuardProtectionEnabled.get();
    }

    public boolean getHologramTitleEnabled() {
        return this.noteTitleEnabled.get();
    }

    public boolean getHologramFooterEnabled() {
        return this.noteFooterEnabled.get();
    }

    public String getHologramFooterType() {
        return this.noteFooterType.get();
    }
}

