/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.config.database;

import dev.silal.soulnotes.config.database.Database;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;

public class MySQLDatabase
implements Database {
    private Connection connection;
    private Statement statement;
    private final String host;
    private final String database;
    private final String user;
    private final String password;
    private final int port;

    public MySQLDatabase(String host, int port, String database, String user, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.user = user;
        this.password = password;
    }

    @Override
    public void connect() throws Exception {
        String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false";
        this.connection = DriverManager.getConnection(url, this.user, this.password);
        if (this.connection != null) {
            this.statement = this.connection.createStatement();
        }
    }

    @Override
    public void disconnect() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setup() throws Exception {
        this.statement.execute("CREATE TABLE IF NOT EXISTS notes (id BIGINT PRIMARY KEY AUTO_INCREMENT, creator VARCHAR(36), message TEXT, created_at TEXT, x DOUBLE, y DOUBLE, z DOUBLE, world TEXT, likes TEXT);");
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }
}

