/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.config.database;

import dev.silal.soulnotes.config.database.Database;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;

public class SQLiteDatabase
implements Database {
    private Connection connection;
    private Statement statement;
    private final File dbFile;

    public SQLiteDatabase(File dbFile) {
        this.dbFile = dbFile;
    }

    @Override
    public void connect() throws Exception {
        String url = "jdbc:sqlite:" + this.dbFile.getAbsolutePath();
        this.connection = DriverManager.getConnection(url);
        if (this.connection != null) {
            this.statement = this.connection.createStatement();
        }
    }

    @Override
    public void disconnect() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setup() throws Exception {
        this.statement.execute("CREATE TABLE IF NOT EXISTS notes (id INTEGER PRIMARY KEY AUTOINCREMENT, creator TEXT, message TEXT, created_at TEXT, x DOUBLE, y DOUBLE, z DOUBLE, world TEXT, likes TEXT);");
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }
}

