/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.listeners.player;

import dev.silal.soulnotes.SoulNotes;
import dev.silal.soulnotes.notes.Note;
import dev.silal.soulnotes.utils.Permissions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerInteractEntityListener
implements Listener {
    public static void addPagedContent(BookMeta meta, String content) {
        int MAX_CHARS_PER_PAGE = 256;
        for (int i = 0; i < content.length(); i += 256) {
            int end = Math.min(i + 256, content.length());
            String page = content.substring(i, end);
            meta.addPage(new String[]{page});
        }
    }

    @EventHandler
    public void onPlayerInteractEntityListener(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!entity.getScoreboardTags().contains("note_display")) {
            return;
        }
        long id = -1L;
        for (String tag : entity.getScoreboardTags()) {
            if (!tag.startsWith("note_id_")) continue;
            String noteId = tag.split("_")[2];
            try {
                id = Integer.valueOf(noteId).intValue();
            }
            catch (Exception e) {
                return;
            }
        }
        if (id == -1L) {
            return;
        }
        try {
            Note note = SoulNotes.getInstance().getNoteManager().getNote(id);
            OfflinePlayer player = null;
            if (note.getCreator() != null) {
                player = SoulNotes.getInstance().getServer().getOfflinePlayer(note.getCreator());
            }
            ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
            BookMeta meta = (BookMeta)book.getItemMeta();
            String noteText = "Author: \u00a72" + (player != null && player.getName() != null ? player.getName() : "Unknown") + "\n\u00a7rCreated at: \u00a76" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(note.getCreatedAt()) + "\n\n\u00a7r\u00a7lNote:\u00a7r\n" + note.getContent();
            PlayerInteractEntityListener.addPagedContent(meta, noteText);
            ArrayList<TextComponent> interactionsPage = new ArrayList<TextComponent>();
            List<UUID> likes = note.getLikes();
            TextComponent like = new TextComponent("\u00a7c" + likes.size() + "\u2665 [Like]");
            like.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/likesoulnote " + id));
            like.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a77Click to like this post")}));
            interactionsPage.add(like);
            if (note.getCreator() != null && note.getCreator().equals(event.getPlayer().getUniqueId()) || event.getPlayer().hasPermission(Permissions.MANAGE_NOTES.perm())) {
                TextComponent component = new TextComponent("\n\n\u00a7c[Delete]");
                component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deletesoulnote " + id));
                component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a77Click to delete this note")}));
                TextComponent creator = new TextComponent("\n\nCreator: \u00a72" + (player != null && player.getName() != null ? player.getName() : "Unknown") + " (" + note.getCreator() + ")");
                TextComponent createdAt = new TextComponent("\nCreated at: \u00a76" + new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(note.getCreatedAt()));
                interactionsPage.add(creator);
                interactionsPage.add(createdAt);
                interactionsPage.add(component);
            }
            meta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{interactionsPage.toArray(new BaseComponent[0])});
            String authorName = player != null && player.getName() != null ? player.getName() : "Unknown";
            meta.setAuthor(authorName);
            meta.setTitle("Soul Note");
            book.setItemMeta((ItemMeta)meta);
            event.getPlayer().openBook(book);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

