/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.notes;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.silal.soulnotes.SoulNotes;
import dev.silal.soulnotes.config.database.util.DatabaseUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;

public class Note {
    private final long id;
    private final SoulNotes plugin;

    public Note(long id, SoulNotes plugin) {
        this.id = id;
        this.plugin = plugin;
    }

    public long getId() {
        return this.id;
    }

    public UUID getCreator() {
        try {
            String uuid = DatabaseUtil.getText("notes", "creator", "id = " + this.id, this.plugin.getDatabase().getStatement()).orElse(null);
            if (uuid == null) {
                return null;
            }
            return UUID.fromString(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getCreatedAt() {
        try {
            String date = DatabaseUtil.getText("notes", "created_at", "id = " + this.id, this.plugin.getDatabase().getStatement()).orElse(null);
            if (date == null) {
                return null;
            }
            return DatabaseUtil.getDate(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContent() {
        try {
            return DatabaseUtil.getText("notes", "message", "id = " + this.id, this.plugin.getDatabase().getStatement()).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Location getLocation() {
        try {
            double x = DatabaseUtil.getDouble("notes", "x", "id = " + this.id, this.plugin.getDatabase().getStatement()).orElse(0.0);
            double y = DatabaseUtil.getDouble("notes", "y", "id = " + this.id, this.plugin.getDatabase().getStatement()).orElse(0.0);
            double z = DatabaseUtil.getDouble("notes", "z", "id = " + this.id, this.plugin.getDatabase().getStatement()).orElse(0.0);
            String w = DatabaseUtil.getText("notes", "world", "id = " + this.id, this.plugin.getDatabase().getStatement()).orElse("world");
            World world = this.plugin.getServer().getWorld(w);
            if (world == null) {
                return null;
            }
            return new Location(world, x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<UUID> getLikes() {
        try {
            String uuidList = DatabaseUtil.getText("notes", "likes", "id = " + this.id, this.plugin.getDatabase().getStatement()).orElse(null);
            List uuidStrings = (List)new Gson().fromJson(uuidList, new TypeToken<List<String>>(){}.getType());
            List<UUID> uuids = uuidStrings.stream().map(UUID::fromString).collect(Collectors.toList());
            return uuids;
        }
        catch (Exception e) {
            return new ArrayList<UUID>();
        }
    }

    public void setLikes(List<UUID> likes) {
        try {
            String json = new Gson().toJson(likes);
            DatabaseUtil.setText("notes", "likes", json, "id = " + this.id, this.plugin.getDatabase().getStatement());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLike(UUID uuid) {
        List<UUID> likes = this.getLikes();
        likes.add(uuid);
        this.setLikes(likes);
    }

    public void removeLike(UUID uuid) {
        List<UUID> likes = this.getLikes();
        if (likes.contains(uuid)) {
            likes.remove(uuid);
            this.setLikes(likes);
        }
    }
}

