/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.notes;

import dev.silal.soulnotes.SoulNotes;
import dev.silal.soulnotes.config.database.util.DatabaseEntry;
import dev.silal.soulnotes.config.database.util.DatabaseUtil;
import dev.silal.soulnotes.notes.Note;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;

public class NoteManager {
    private final SoulNotes plugin;

    public NoteManager(SoulNotes plugin) {
        this.plugin = plugin;
    }

    public boolean noteExists(long id) {
        try {
            return DatabaseUtil.entryExists("notes", "id = " + id, this.plugin.getDatabase().getStatement());
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getPlayerNoteCount(UUID uuid) {
        try {
            return DatabaseUtil.countEntries("notes", "uuid = " + uuid.toString(), this.plugin.getDatabase().getStatement());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public Note getNote(long id) {
        if (!this.noteExists(id)) {
            return null;
        }
        return new Note(id, this.plugin);
    }

    public void deleteNote(long id) {
        if (!this.noteExists(id)) {
            return;
        }
        DatabaseUtil.delete("notes", "id = " + id, this.plugin.getDatabase().getStatement());
        this.plugin.getNoteSpawner().deleteNote(id);
    }

    public Note createNote(UUID creator, String message, Location location) {
        Timestamp now = Timestamp.valueOf(LocalDateTime.now());
        try {
            PreparedStatement stmt = this.plugin.getDatabase().getConnection().prepareStatement("INSERT INTO notes (`creator`, `message`, `created_at`, `x`, `y`, `z`, `world`) VALUES (?, ?, ?, ?, ?, ?, ?)", 1);
            stmt.setString(1, creator.toString());
            stmt.setString(2, message);
            stmt.setString(3, DatabaseUtil.getDateString(now));
            stmt.setDouble(4, location.getX());
            stmt.setDouble(5, location.getY());
            stmt.setDouble(6, location.getZ());
            stmt.setString(7, location.getWorld().getName());
            stmt.executeUpdate();
            ResultSet generatedKeys = stmt.getGeneratedKeys();
            if (generatedKeys.next()) {
                long id = generatedKeys.getLong(1);
                Note note = this.getNote(id);
                if (note != null && this.plugin.getNoteSpawner() != null) {
                    this.plugin.getNoteSpawner().spawnNote(note);
                }
                return note;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<Note> getAllNotes() {
        ArrayList<Note> finalList = new ArrayList<Note>();
        try {
            for (DatabaseEntry entry : DatabaseUtil.getAllEntries("notes", null, this.plugin.getDatabase().getStatement())) {
                int id = entry.getInt("id");
                if (!this.noteExists(id)) continue;
                finalList.add(this.getNote(id));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return finalList;
    }

    public List<Note> getAllNotes(UUID uuid) {
        ArrayList<Note> finalList = new ArrayList<Note>();
        try {
            for (DatabaseEntry entry : DatabaseUtil.getAllEntries("notes", "creator = '" + uuid.toString() + "'", this.plugin.getDatabase().getStatement())) {
                int id = entry.getInt("id");
                if (!this.noteExists(id)) continue;
                finalList.add(this.getNote(id));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return finalList;
    }

    public List<Note> getNotesInRadius(Location center, double radius) {
        ArrayList<Note> result = new ArrayList<Note>();
        String worldName = center.getWorld().getName();
        double radiusSquared = radius * radius;
        try {
            String query = "SELECT id, x, y, z, world FROM notes WHERE world = '" + worldName.replace("'", "''") + "'";
            ResultSet rs = this.plugin.getDatabase().getStatement().executeQuery(query);
            while (rs.next()) {
                double dz;
                double dy;
                double x = rs.getDouble("x");
                double y = rs.getDouble("y");
                double z = rs.getDouble("z");
                String world = rs.getString("world");
                double dx = x - center.getX();
                double distanceSquared = dx * dx + (dy = y - center.getY()) * dy + (dz = z - center.getZ()) * dz;
                if (!(distanceSquared <= radiusSquared)) continue;
                int id = rs.getInt("id");
                result.add(this.getNote(id));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

