/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.notes.spawner;

import dev.silal.soulnotes.SoulNotes;
import dev.silal.soulnotes.notes.Note;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Display;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class NoteSpawner {
    private final SoulNotes plugin;

    public NoteSpawner(SoulNotes plugin) {
        this.plugin = plugin;
    }

    public void deleteNote(long id) {
        Bukkit.getServer().getWorlds().forEach(world -> world.getEntities().stream().filter(entity -> entity.getScoreboardTags().contains("note_id_" + id) && entity.getScoreboardTags().contains("note_display")).forEach(entity -> entity.remove()));
    }

    public void spawnNote(Note note) {
        long id = note.getId();
        Location location = note.getLocation();
        if (location == null || location.getWorld() == null) {
            return;
        }
        UUID creator = note.getCreator();
        OfflinePlayer player = null;
        if (creator != null) {
            player = this.plugin.getServer().getOfflinePlayer(creator);
        }
        if (this.plugin.getConfiguration().getHologramTitleEnabled()) {
            TextDisplay title = (TextDisplay)location.getWorld().spawn(location.clone().add(0.0, 1.5, 0.0), TextDisplay.class);
            title.setText((String)(player == null || player.getName() == null ? "\u00a78\u270e\u00a77 Read message" : "\u00a78\u270e\u00a77 Read message of \u00a7e" + player.getName()));
            title.setAlignment(TextDisplay.TextAlignment.CENTER);
            title.setDefaultBackground(false);
            title.setPersistent(true);
            title.setBillboard(Display.Billboard.VERTICAL);
            title.addScoreboardTag("note_display");
            title.addScoreboardTag("note_title");
            title.addScoreboardTag("note_id_" + id);
        }
        if (this.plugin.getConfiguration().getHologramFooterEnabled()) {
            Date created = note.getCreatedAt();
            TextDisplay footer = (TextDisplay)location.getWorld().spawn(location.clone().add(0.0, 1.2, 0.0), TextDisplay.class);
            if (this.plugin.getConfiguration().getHologramFooterType().equalsIgnoreCase("likes")) {
                footer.setText("\u00a7c" + note.getLikes().size() + "\u2665");
            } else {
                footer.setText((String)(created == null ? "\u00a7eUnknown" : "\u00a7a" + new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(created)));
            }
            footer.setAlignment(TextDisplay.TextAlignment.CENTER);
            footer.setDefaultBackground(false);
            footer.setPersistent(true);
            footer.setBillboard(Display.Billboard.VERTICAL);
            footer.addScoreboardTag("note_display");
            footer.addScoreboardTag("note_created");
            footer.addScoreboardTag("note_id_" + id);
        }
        ItemDisplay book = (ItemDisplay)location.getWorld().spawn(location.clone().add(0.0, 0.05, 0.0), ItemDisplay.class);
        book.setItemStack(new ItemStack(Material.WRITTEN_BOOK));
        book.setRotation(0.0f, 90.0f);
        book.setGravity(false);
        book.setPersistent(true);
        book.setInvulnerable(true);
        book.setTransformation(new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new AxisAngle4f(), new Vector3f(0.5f, 0.5f, 0.5f), new AxisAngle4f()));
        book.addScoreboardTag("note_display");
        book.addScoreboardTag("note_book");
        book.addScoreboardTag("note_id_" + id);
        Interaction interaction = (Interaction)location.getWorld().spawn(location, Interaction.class);
        interaction.setInteractionHeight(0.5f);
        interaction.setInteractionWidth(0.5f);
        interaction.addScoreboardTag("note_display");
        interaction.addScoreboardTag("note_interaction");
        interaction.addScoreboardTag("note_id_" + id);
    }

    public void removeAllNotes() {
        this.plugin.getServer().getWorlds().forEach(world -> world.getEntities().forEach(entity -> {
            if (entity.getScoreboardTags().contains("note_display")) {
                entity.remove();
            }
        }));
    }

    public void spawnAllNotes() {
        for (Note note : this.plugin.getNoteManager().getAllNotes()) {
            this.spawnNote(note);
        }
    }
}

