/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;

public class JsonManager {
    private JsonObject jsonObject;

    public JsonManager() {
        this.jsonObject = new JsonObject();
    }

    public JsonManager(String json) {
        this.jsonObject = json != null && !json.isEmpty() ? JsonParser.parseString((String)json).getAsJsonObject() : new JsonObject();
    }

    public JsonObject jsonObject() {
        return this.jsonObject;
    }

    public JsonManager addProperty(String key, String value) {
        this.removeProperty(key);
        this.jsonObject.addProperty(key, value);
        return this;
    }

    public JsonManager addProperty(String key, Number value) {
        this.removeProperty(key);
        this.jsonObject.addProperty(key, value);
        return this;
    }

    public JsonManager addProperty(String key, Boolean value) {
        this.removeProperty(key);
        this.jsonObject.addProperty(key, value);
        return this;
    }

    public JsonManager addProperty(String key, JsonObject value) {
        this.removeProperty(key);
        this.jsonObject.add(key, (JsonElement)value);
        return this;
    }

    public JsonManager addProperty(String key, JsonArray value) {
        this.removeProperty(key);
        this.jsonObject.add(key, (JsonElement)value);
        return this;
    }

    public JsonManager addProperty(String key, JsonManager value) {
        this.removeProperty(key);
        this.jsonObject.add(key, (JsonElement)value.jsonObject);
        return this;
    }

    public JsonManager addProperty(String key, List<?> values) {
        this.removeProperty(key);
        JsonArray jsonArray = new JsonArray();
        for (Object value : values) {
            if (value instanceof String) {
                jsonArray.add((String)value);
                continue;
            }
            if (value instanceof Number) {
                jsonArray.add((Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                jsonArray.add((Boolean)value);
                continue;
            }
            if (!(value instanceof JsonObject)) continue;
            jsonArray.add((JsonElement)((JsonObject)value));
        }
        this.jsonObject.add(key, (JsonElement)jsonArray);
        return this;
    }

    public JsonManager removeProperty(String key) {
        this.jsonObject.remove(key);
        return this;
    }

    public String toJsonString() {
        return new Gson().toJson((JsonElement)this.jsonObject);
    }

    public static boolean isValidJson(String json) {
        try {
            JsonParser.parseString((String)json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String makePrettier(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String prettyJson = gson.toJson(gson.fromJson(json, Object.class));
        return prettyJson;
    }

    public boolean hasKey(String key) {
        return this.jsonObject.has(key);
    }

    public String getString(String key) {
        return this.jsonObject.get(key).getAsString();
    }

    public Number getNumber(String key) {
        return this.jsonObject.get(key).getAsNumber();
    }

    public Boolean getBoolean(String key) {
        return this.jsonObject.get(key).getAsBoolean();
    }

    public JsonObject getObject(String key) {
        return this.jsonObject.get(key).getAsJsonObject();
    }

    public JsonArray getArray(String key) {
        return this.jsonObject.get(key).getAsJsonArray();
    }
}

