/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.utils.config;

import dev.silal.soulnotes.utils.config.Configuration;
import java.util.UUID;
import org.bukkit.Material;

public class ConfigValue<T> {
    private Configuration conf;
    private final String key;
    private final Class<T> type;
    private T defaultValue = null;

    public ConfigValue(String key, Class<T> type, Configuration configuration) {
        this.key = key;
        this.type = type;
        this.conf = configuration;
    }

    public ConfigValue(String key, Class<T> type, Configuration configuration, T defaultValue) {
        this.key = key;
        this.type = type;
        this.conf = configuration;
        this.defaultValue = defaultValue;
        if (configuration.yamlConfiguration().get(key) != null) {
            return;
        }
        this.set(defaultValue);
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public void set(T value) {
        if (this.type == UUID.class) {
            this.conf.save(this.key, ((UUID)value).toString());
            return;
        }
        this.conf.save(this.key, value);
    }

    public T get() {
        if (this.conf.yamlConfiguration().get(this.key) == null && this.defaultValue != null) {
            this.conf.save(this.key, this.defaultValue);
            return this.defaultValue;
        }
        if (this.type == UUID.class) {
            return (T)UUID.fromString(this.conf.yamlConfiguration().getString(this.key));
        }
        if (this.type == Long.class) {
            return (T)Long.valueOf(this.conf.yamlConfiguration().getLong(this.key));
        }
        if (this.type == Material.class) {
            return (T)Material.getMaterial((String)this.conf.yamlConfiguration().getString(this.key));
        }
        return (T)this.conf.yamlConfiguration().get(this.key);
    }
}

