/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.utils.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class Configuration {
    private final String path;
    private YamlConfiguration configuration = new YamlConfiguration();

    public Configuration(String path) {
        this.path = path;
        File file = new File(path);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
    }

    public void save(String key, Object value) {
        try {
            this.configuration.set(key, value);
            File conf = new File(this.path);
            this.configuration.save(conf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            File conf = new File(this.path);
            this.configuration.save(conf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean deleteFile() {
        File file = new File(this.path);
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    public List<String> getKeys(String key) {
        ConfigurationSection section = this.configuration.getConfigurationSection(key);
        if (section == null) {
            return new ArrayList<String>();
        }
        return section.getKeys(false).stream().toList();
    }

    public void editKey(String key, String newKey) {
        Object value = this.configuration.get(key);
        this.configuration.set(key, null);
        this.configuration.set(newKey, value);
        this.save();
    }

    public void remove(String key) {
        this.configuration.set(key, null);
        this.save();
    }

    public String path() {
        return this.path;
    }

    public YamlConfiguration yamlConfiguration() {
        return this.configuration;
    }
}

