/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.utils.config;

import dev.silal.soulnotes.utils.config.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ListConfigValue<T> {
    private final String key;
    private final Configuration conf;
    private List<T> defaultValue;
    private Class<T> type;

    public ListConfigValue(String key, Class<T> type, Configuration configuration) {
        this.key = key;
        this.type = type;
        this.conf = configuration;
    }

    public ListConfigValue(String key, Class<T> type, Configuration configuration, List<T> defaultValue) {
        this.key = key;
        this.type = type;
        this.conf = configuration;
        this.defaultValue = defaultValue;
    }

    public List<T> get() {
        if (this.conf.yamlConfiguration().getList(this.key) == null && this.defaultValue == null) {
            return new ArrayList();
        }
        if (this.conf.yamlConfiguration().getList(this.key) == null && this.defaultValue != null) {
            this.set(this.defaultValue);
            return this.defaultValue;
        }
        if (this.type == UUID.class) {
            ArrayList<UUID> re = new ArrayList<UUID>();
            for (Object o : this.conf.yamlConfiguration().getList(this.key)) {
                re.add(UUID.fromString(String.valueOf(o)));
            }
            return re;
        }
        if (Enum.class.isAssignableFrom(this.type)) {
            ArrayList<T> re = new ArrayList<T>();
            for (Object o : this.conf.yamlConfiguration().getList(this.key)) {
                if (!(o instanceof String)) continue;
                T enumValue = Enum.valueOf(this.type, (String)o);
                re.add(enumValue);
            }
            return re;
        }
        return this.conf.yamlConfiguration().getList(this.key);
    }

    public void set(List<T> value) {
        if (this.type == UUID.class) {
            ArrayList<String> save = new ArrayList<String>();
            for (T o : value) {
                save.add(((UUID)o).toString());
            }
            this.conf.save(this.key, save);
            return;
        }
        if (Enum.class.isAssignableFrom(this.type)) {
            ArrayList<String> save = new ArrayList<String>();
            for (T o : value) {
                save.add(((Enum)o).name());
            }
            this.conf.save(this.key, save);
            return;
        }
        this.conf.save(this.key, value);
    }
}

