/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.utils.config;

import dev.silal.soulnotes.utils.config.Configuration;
import java.util.HashMap;
import java.util.Map;

public class MapConfigValue<T> {
    private final String key;
    private final Configuration conf;
    private final Map<String, T> defaultValue;

    public MapConfigValue(String key, Configuration configuration) {
        this.key = key;
        this.conf = configuration;
        this.defaultValue = null;
    }

    public MapConfigValue(String key, Configuration configuration, Map<String, T> defaultValue) {
        this.key = key;
        this.conf = configuration;
        this.defaultValue = defaultValue;
    }

    public Map<String, T> get() {
        if (this.conf.yamlConfiguration().getConfigurationSection(this.key) == null && this.defaultValue == null) {
            return new HashMap();
        }
        if (this.conf.yamlConfiguration().getConfigurationSection(this.key) == null) {
            this.set(this.defaultValue);
            return this.defaultValue;
        }
        Map rawMap = this.conf.yamlConfiguration().getConfigurationSection(this.key).getValues(false);
        HashMap result = new HashMap();
        return rawMap;
    }

    public void set(Map<String, T> value) {
        if (this.conf.yamlConfiguration().getConfigurationSection(this.key) != null) {
            Map rawMap = this.conf.yamlConfiguration().getConfigurationSection(this.key).getValues(false);
            for (Map.Entry entry : rawMap.entrySet()) {
                this.conf.remove(this.key + "." + (String)entry.getKey());
            }
        }
        for (Map.Entry<String, T> entry : value.entrySet()) {
            this.conf.save(this.key + "." + entry.getKey(), entry.getValue());
        }
    }
}

