/*
 * Decompiled with CFR 0.152.
 */
package dev.silal.soulnotes.utils.database;

import dev.silal.soulnotes.utils.database.ColType;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DatabaseTableCreator {
    private String tableName;
    private boolean checkExists;
    private final Map<String, Map<String, Object>> cols = new LinkedHashMap<String, Map<String, Object>>();

    public DatabaseTableCreator(String tableName, boolean checkExists) {
        this.tableName = tableName;
        this.checkExists = checkExists;
    }

    public DatabaseTableCreator(String tableName) {
        this(tableName, false);
    }

    public DatabaseTableCreator() {
        this(null, false);
    }

    public void setTableName(String name) {
        this.tableName = name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setCheckExists(boolean b) {
        this.checkExists = b;
    }

    public boolean getCheckExists() {
        return this.checkExists;
    }

    public void addCol(String name, ColType type) {
        this.cols.put(name, Map.of("type", type));
    }

    public void addCol(String name, ColType type, boolean nn) {
        this.cols.put(name, Map.of("type", type, "nn", nn));
    }

    public void addCol(String name, ColType type, boolean nn, boolean pk) {
        this.cols.put(name, Map.of("type", type, "nn", nn, "pk", pk));
    }

    public void addColWithDefault(String name, ColType type, boolean nn, boolean pk, String defaultVal) {
        HashMap<String, Object> colProps = new HashMap<String, Object>();
        colProps.put("type", (Object)type);
        colProps.put("nn", nn);
        colProps.put("pk", pk);
        colProps.put("default", defaultVal);
        this.cols.put(name, colProps);
    }

    public void removeCol(String name) {
        this.cols.remove(name);
    }

    public void removeCol(ColType type) {
        this.cols.entrySet().removeIf(entry -> type.equals(((Map)entry.getValue()).get("type")));
    }

    public List<String> getSQL() {
        if (this.tableName == null || this.cols.isEmpty()) {
            return List.of();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        if (this.checkExists) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.tableName).append(" (\n");
        ArrayList<String> colDefs = new ArrayList<String>();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (Map.Entry<String, Map<String, Object>> entry : this.cols.entrySet()) {
            String name = entry.getKey();
            Map<String, Object> properties = entry.getValue();
            ColType type = (ColType)((Object)properties.get("type"));
            StringBuilder colDef = new StringBuilder();
            colDef.append(name).append(" ").append((Object)type);
            if (Boolean.TRUE.equals(properties.get("nn"))) {
                colDef.append(" NOT NULL");
            }
            if (properties.containsKey("default")) {
                Object defaultVal = (String)properties.get("default");
                if (type == ColType.TEXT || type == ColType.BLOB) {
                    defaultVal = "'" + ((String)defaultVal).replace("'", "''") + "'";
                }
                colDef.append(" DEFAULT ").append((String)defaultVal);
            }
            if (Boolean.TRUE.equals(properties.get("pk"))) {
                primaryKeys.add(name);
            }
            colDefs.add(colDef.toString());
        }
        sb.append(String.join((CharSequence)",\n", colDefs));
        if (!primaryKeys.isEmpty()) {
            sb.append(",\nPRIMARY KEY (").append(String.join((CharSequence)", ", primaryKeys)).append(")");
        }
        sb.append("\n);");
        return List.of(sb.toString());
    }

    public boolean create(Statement statement) {
        List<String> sqlList = this.getSQL();
        if (sqlList.isEmpty()) {
            return false;
        }
        try {
            for (String sql : sqlList) {
                statement.execute(sql);
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }
}

