/*
 * Decompiled with CFR 0.152.
 */
package de.nikey.combatLog.Listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AntiKillAbuse
implements Listener {
    private final JavaPlugin plugin;
    private final Map<UUID, Map<UUID, List<Long>>> killHistory = new HashMap<UUID, Map<UUID, List<Long>>>();
    private final int maxKills;
    private final int killRemove;
    private final List<String> punishCommands;

    public AntiKillAbuse(JavaPlugin plugin) {
        this.plugin = plugin;
        FileConfiguration config = plugin.getConfig();
        this.maxKills = config.getInt("anti-kill-abuse.max-kills", 3);
        this.punishCommands = config.getStringList("anti-kill-abuse.punish-commands");
        this.killRemove = config.getInt("anti-kill-abuse.remove-kill-after", 60);
        if (config.getBoolean("anti-kill-abuse.enabled", true)) {
            this.startCheckTask();
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity().getKiller();
        if (!(player instanceof Player)) {
            return;
        }
        Player killer = player;
        Player victim = event.getEntity();
        long now = System.currentTimeMillis();
        this.killHistory.computeIfAbsent(killer.getUniqueId(), k -> new HashMap()).computeIfAbsent(victim.getUniqueId(), v -> new ArrayList()).add(now);
    }

    private void startCheckTask() {
        new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                long window = (long)AntiKillAbuse.this.killRemove * 1000L;
                for (UUID killerId : new HashSet<UUID>(AntiKillAbuse.this.killHistory.keySet())) {
                    Map<UUID, List<Long>> victimKills = AntiKillAbuse.this.killHistory.get(killerId);
                    if (victimKills == null) continue;
                    for (Map.Entry<UUID, List<Long>> entry : victimKills.entrySet()) {
                        List<Long> kills = entry.getValue();
                        kills.removeIf(time -> now - time > window);
                        if (kills.size() <= AntiKillAbuse.this.maxKills) continue;
                        Player killer = Bukkit.getPlayer((UUID)killerId);
                        if (killer != null && killer.isOnline()) {
                            for (String cmd : AntiKillAbuse.this.punishCommands) {
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("{killer}", killer.getName()).replace("{victim}", Optional.ofNullable(Bukkit.getPlayer((UUID)entry.getKey())).map(Player::getName).orElse("Unknown")));
                            }
                        }
                        kills.clear();
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 500L, 500L);
    }
}

