/*
 * Decompiled with CFR 0.152.
 */
package de.nikey.combatLog.Listener;

import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import de.nikey.combatLog.CombatLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GeneralListener
implements Listener {
    public static final HashMap<UUID, Integer> combatTimers = new HashMap();
    public static final HashMap<UUID, BukkitRunnable> activeTimers = new HashMap();
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    private final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity shooter;
        List ignoredWorlds = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getStringList("combat-log.ignored-worlds");
        if (ignoredWorlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player damaged = (Player)entity;
            entity = event.getDamager();
            if (entity instanceof Player) {
                Player damager = (Player)entity;
                if (damaged == damager) {
                    return;
                }
                this.cancelCombatTimer(damaged);
                this.cancelCombatTimer(damager);
                this.startCombatTimer(damaged);
                this.startCombatTimer(damager);
                damaged.setGliding(false);
                damager.setGliding(false);
                return;
            }
        }
        if ((entity = event.getDamager()) instanceof Arrow) {
            Arrow damager = (Arrow)entity;
            shooter = damager.getShooter();
            if (!(shooter instanceof Player)) return;
            Player player = (Player)shooter;
            Entity entity2 = event.getEntity();
            if (!(entity2 instanceof Player)) return;
            Player damaged = (Player)entity2;
            if (player == damaged) {
                return;
            }
            this.cancelCombatTimer(damaged);
            this.cancelCombatTimer(player);
            this.startCombatTimer(damaged);
            this.startCombatTimer(player);
            damaged.setGliding(false);
            player.setGliding(false);
            return;
        }
        shooter = event.getDamager();
        if (shooter instanceof Trident) {
            Trident damager = (Trident)shooter;
            if (!((shooter = damager.getShooter()) instanceof Player)) return;
            Player player = (Player)shooter;
            Entity entity3 = event.getEntity();
            if (!(entity3 instanceof Player)) return;
            Player damaged = (Player)entity3;
            if (player == damaged) {
                return;
            }
            this.cancelCombatTimer(damaged);
            this.cancelCombatTimer(player);
            this.startCombatTimer(damaged);
            this.startCombatTimer(player);
            damaged.setGliding(false);
            player.setGliding(false);
            return;
        }
        shooter = event.getDamager();
        if (!(shooter instanceof WitherSkull)) return;
        WitherSkull skull = (WitherSkull)shooter;
        if (!((shooter = skull.getShooter()) instanceof Player)) return;
        Player player = (Player)shooter;
        Entity entity4 = event.getEntity();
        if (!(entity4 instanceof Player)) return;
        Player damaged = (Player)entity4;
        if (player == damaged) {
            return;
        }
        this.cancelCombatTimer(damaged);
        this.cancelCombatTimer(player);
        this.startCombatTimer(damaged);
        this.startCombatTimer(player);
        damaged.setGliding(false);
        player.setGliding(false);
    }

    private boolean isAfk(Player player) {
        return player.hasMetadata("afk") && ((MetadataValue)player.getMetadata("afk").get(0)).asBoolean();
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getBoolean("combat-log.combat-zone.enabled", false)) {
            return;
        }
        final List ignoredWorlds = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getStringList("combat-log.ignored-worlds");
        final Player player = event.getPlayer();
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                double radius = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getDouble("combat-log.combat-zone.radius", 10.0);
                if (player.getGameMode() == GameMode.SPECTATOR || player.getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                for (Player players : player.getWorld().getNearbyPlayers(player.getLocation(), radius)) {
                    if (player == players || players.isDead() || players.getGameMode() == GameMode.SPECTATOR || players.getGameMode() == GameMode.CREATIVE) continue;
                    if (ignoredWorlds.contains(players.getWorld().getName())) {
                        return;
                    }
                    GeneralListener.this.cancelCombatTimer(players);
                    GeneralListener.this.cancelCombatTimer(player);
                    GeneralListener.this.startCombatTimer(player);
                    GeneralListener.this.startCombatTimer(players);
                }
            }
        }.runTaskTimer((Plugin)CombatLog.getPlugin(CombatLog.class), 0L, 20L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        final Player player = event.getPlayer();
        if (!((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getBoolean("combat-log.stop-riptiding", false)) {
            return;
        }
        if (!combatTimers.containsKey(player.getUniqueId())) {
            return;
        }
        if (player.isRiptiding()) {
            long lastThrowTime;
            final long currentTime = System.currentTimeMillis();
            if (currentTime - (lastThrowTime = this.playerCooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) >= (long)((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getInt("combat-log.cooldown", 10000)) {
                new BukkitRunnable(){

                    public void run() {
                        GeneralListener.this.playerCooldowns.put(player.getUniqueId(), currentTime);
                    }
                }.runTaskLater((Plugin)CombatLog.getPlugin(CombatLog.class), 40L);
            } else {
                event.setCancelled(true);
                double damage = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getDouble("combat-log.punishment-damage", 0.0);
                player.damage(damage);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (combatTimers.containsKey(player.getUniqueId())) {
            String combatLogMessage = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getString("combat-log.messages.combat-log", "&c{player} has combat logged!").replace("{player}", player.getName());
            TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(combatLogMessage);
            Bukkit.broadcast((Component)component);
            if (((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getBoolean("combat-log.kill_when_log", false)) {
                player.setHealth(0.0);
            }
            this.cancelCombatTimer(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        boolean teleporting = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getBoolean("combat-log.teleporting-disabled-in-combat");
        if (teleporting && combatTimers.containsKey(player.getUniqueId())) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.UNKNOWN) {
                return;
            }
            event.setCancelled(true);
            String message = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getString("combat-log.messages.teleporting-denied", "\u00a7dYou can't teleport in combat");
            TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
            player.sendMessage((Component)component);
            double damage = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getDouble("combat-log.punishment-damage", 0.0);
            player.damage(damage);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message;
        Player player = event.getPlayer();
        if (!combatTimers.containsKey(player.getUniqueId())) {
            return;
        }
        String[] args = event.getMessage().split(" ");
        List stringList = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getStringList("combat-log.blocked-commands");
        if (stringList.contains(message = args[0].substring(1))) {
            event.setCancelled(true);
            player.sendMessage(((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getString("combat-log.messages.blocked-command", "\u00a7cYou can't use this command in combat"));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityToggleGlide(EntityToggleGlideEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean elytraDisabled = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getBoolean("combat-log.elytra-disabled-in-combat");
            if (elytraDisabled && combatTimers.containsKey(player.getUniqueId()) && event.isGliding()) {
                player.setGliding(false);
                event.setCancelled(true);
                double damage = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getDouble("combat-log.punishment-damage", 0.0);
                player.damage(damage);
                String message = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getString("combat-log.messages.elytra-use-denied", "&dYou can't use elytra in combat");
                TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
                player.sendMessage((Component)component);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerElytraBoost(PlayerElytraBoostEvent event) {
        Player player = event.getPlayer();
        if (((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getBoolean("combat-log.elytra-disabled-in-combat") && combatTimers.containsKey(player.getUniqueId())) {
            event.setCancelled(true);
            double damage = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getDouble("combat-log.punishment-damage", 0.0);
            player.damage(damage);
            String message = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getString("combat-log.messages.elytra-use-denied", "&dYou can't use elytra in combat");
            TextComponent component = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
            player.sendMessage((Component)component);
        }
    }

    private void startCombatTimer(final Player player) {
        final UUID playerId = player.getUniqueId();
        boolean elytraDisabled = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getBoolean("combat-log.elytra-disabled-in-combat");
        if (elytraDisabled) {
            player.setGliding(false);
        }
        final int timerDuration = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getInt("combat-log.timer-duration");
        final String displayType = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getString("combat-log.timer-display", "actionbar").toLowerCase();
        if (combatTimers.containsKey(playerId)) {
            combatTimers.put(playerId, timerDuration);
            return;
        }
        if (this.isAfk(player)) {
            player.showTitle(Title.title((Component)Component.empty(), (Component)Component.text((String)"Please disable afk, you are in combat!").color((TextColor)NamedTextColor.RED)));
        }
        combatTimers.put(playerId, timerDuration);
        if (displayType.equals("bossbar")) {
            BossBar bossBar = BossBar.bossBar((Component)Component.text((String)""), (float)1.0f, (BossBar.Color)BossBar.Color.RED, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
            bossBar.addViewer((Audience)player);
            this.bossBars.put(playerId, bossBar);
        }
        BukkitRunnable timerTask = new BukkitRunnable(){

            public void run() {
                if (!player.isValid()) {
                    GeneralListener.this.cleanup(playerId);
                    this.cancel();
                    return;
                }
                Integer timeLeft = combatTimers.get(playerId);
                if (timeLeft == null) {
                    GeneralListener.this.cleanup(playerId);
                    this.cancel();
                    return;
                }
                if (timeLeft > 0) {
                    BossBar bar;
                    combatTimers.put(playerId, timeLeft - 1);
                    if (displayType.equals("actionbar")) {
                        String actionBarMessage = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getString("combat-log.messages.action-bar-timer", "&c{timeLeft}/{maxTime}").replace("{timeLeft}", String.valueOf(timeLeft)).replace("{maxTime}", String.valueOf(timerDuration));
                        player.sendActionBar((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(actionBarMessage));
                    } else if (displayType.equals("bossbar") && (bar = GeneralListener.this.bossBars.get(playerId)) != null) {
                        String bossBarText = ((CombatLog)CombatLog.getPlugin(CombatLog.class)).getConfig().getString("combat-log.messages.bossbar-title", "&cIm Kampf: {timeLeft}s").replace("{timeLeft}", String.valueOf(timeLeft));
                        bar.name((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(bossBarText));
                        bar.progress((float)timeLeft.intValue() / (float)timerDuration);
                    }
                } else {
                    GeneralListener.this.cleanup(playerId);
                    this.cancel();
                }
            }
        };
        timerTask.runTaskTimer((Plugin)CombatLog.getPlugin(CombatLog.class), 0L, 20L);
        activeTimers.put(playerId, timerTask);
    }

    private void cancelCombatTimer(Player player) {
        UUID playerId = player.getUniqueId();
        this.cleanup(playerId);
    }

    private void cleanup(UUID playerId) {
        BossBar bossBar;
        combatTimers.remove(playerId);
        if (activeTimers.containsKey(playerId)) {
            activeTimers.get(playerId).cancel();
            activeTimers.remove(playerId);
        }
        if ((bossBar = this.bossBars.remove(playerId)) != null) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                bossBar.removeViewer((Audience)online);
            }
        }
    }
}

