/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.ScreenUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2594473;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3268052;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3784880;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import net.minecraft.unmapped.C_9468736;
import net.minecraft.unmapped.C_9550253;

public class DescriptionListWidget
extends C_1630332
implements C_3268052 {
    private static final C_9550253 HAS_UPDATE_TEXT = new C_1160932("modmenu.hasUpdate", new Object[0]);
    private static final C_9550253 EXPERIMENTAL_TEXT = new C_1160932("modmenu.experimental", new Object[0]).m_7551367(new C_6237110().m_0282611(C_1945050.f_0313642));
    private static final C_9550253 DOWNLOAD_TEXT = new C_1160932("modmenu.downloadLink", new Object[0]).m_7551367(new C_6237110().m_0282611(C_1945050.f_7743109).m_9739860(Boolean.valueOf(true)));
    private static final C_9550253 CHILD_HAS_UPDATE_TEXT = new C_1160932("modmenu.childHasUpdate", new Object[0]);
    private static final C_9550253 LINKS_TEXT = new C_1160932("modmenu.links", new Object[0]);
    private static final C_9550253 SOURCE_TEXT = new C_1160932("modmenu.source", new Object[0]).m_7551367(new C_6237110().m_0282611(C_1945050.f_7743109).m_9739860(Boolean.valueOf(true)));
    private static final C_9550253 LICENSE_TEXT = new C_1160932("modmenu.license", new Object[0]);
    private static final C_9550253 VIEW_CREDITS_TEXT = new C_1160932("modmenu.viewCredits", new Object[0]).m_7551367(new C_6237110().m_0282611(C_1945050.f_7743109).m_9739860(Boolean.valueOf(true)));
    private static final C_9550253 CREDITS_TEXT = new C_1160932("modmenu.credits", new Object[0]);
    private final ModsScreen parent;
    private final C_3831727 textRenderer;
    private final List<DescriptionEntry> entries = new ArrayList<DescriptionEntry>();
    private ModListEntry lastSelected = null;

    public DescriptionListWidget(C_8105098 client, int width, int height, int top, int bottom, int entryHeight, ModsScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.parent = parent;
        this.textRenderer = client.f_0426313;
    }

    public int m_6519286() {
        return this.f_2695432 - 10;
    }

    protected int m_3021017() {
        return this.f_2695432 - 6 + this.f_8129586;
    }

    public boolean isMouseInList(int mouseX, int mouseY) {
        return mouseY >= this.f_9975269 && mouseY <= this.f_9145833 && mouseX >= this.f_8129586 && mouseX <= this.f_7901480;
    }

    public int m_3791031() {
        return this.entries.size();
    }

    public void clear() {
        this.entries.clear();
    }

    public DescriptionEntry getEntry(int index) {
        return this.entries.get(index);
    }

    public void m_9734698(int mouseX, int mouseY, float delta) {
        this.f_9602731 = mouseX;
        this.f_1139530 = mouseY;
        this.m_7189774();
        ModListEntry selectedEntry = this.parent.getSelectedEntry();
        if (selectedEntry != this.lastSelected) {
            this.lastSelected = selectedEntry;
            this.clear();
            if (this.lastSelected != null) {
                DescriptionEntry emptyEntry = new DescriptionEntry("");
                int wrapWidth = this.m_6519286() - 5;
                Mod mod = this.lastSelected.getMod();
                String description = mod.getTranslatedDescription();
                if (!description.isEmpty()) {
                    for (Object line : this.textRenderer.m_0466830(description.replaceAll("\n", "\n\n"), wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)line));
                    }
                }
                if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(mod.getId())) {
                    Object entry;
                    UpdateInfo updateInfo = mod.getUpdateInfo();
                    if (updateInfo != null && updateInfo.isUpdateAvailable()) {
                        this.entries.add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.m_0466830(HAS_UPDATE_TEXT.m_2117196(), wrapWidth - 11)) {
                            entry = new DescriptionEntry((String)line);
                            if (index == 0) {
                                ((DescriptionEntry)entry).setUpdateTextEntry();
                            }
                            this.entries.add((DescriptionEntry)entry);
                            ++index;
                        }
                        for (Object line : this.textRenderer.m_0466830(EXPERIMENTAL_TEXT.m_2117196(), wrapWidth - 16)) {
                            this.entries.add(new DescriptionEntry((String)line, 8));
                        }
                        C_9550253 updateMessage = updateInfo.getUpdateMessage();
                        String downloadLink = updateInfo.getDownloadLink();
                        if (updateMessage == null) {
                            updateMessage = DOWNLOAD_TEXT;
                        } else if (downloadLink != null) {
                            updateMessage = updateMessage.m_6415269().m_7551367(new C_6237110().m_0282611(C_1945050.f_7743109).m_9739860(Boolean.valueOf(true)));
                        }
                        for (Object line : this.textRenderer.m_0466830(updateMessage.m_2117196(), wrapWidth - 16)) {
                            if (downloadLink != null) {
                                this.entries.add(new LinkEntry((String)line, downloadLink, 8));
                                continue;
                            }
                            this.entries.add(new DescriptionEntry((String)line, 8));
                        }
                    }
                    if (mod.getChildHasUpdate()) {
                        this.entries.add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.m_0466830(CHILD_HAS_UPDATE_TEXT.m_2117196(), wrapWidth - 11)) {
                            entry = new DescriptionEntry((String)line);
                            if (index == 0) {
                                ((DescriptionEntry)entry).setUpdateTextEntry();
                            }
                            this.entries.add((DescriptionEntry)entry);
                            ++index;
                        }
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                    this.entries.add(emptyEntry);
                    for (Object line : this.textRenderer.m_0466830(LINKS_TEXT.m_2117196(), wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object line : this.textRenderer.m_0466830(SOURCE_TEXT.m_2117196(), wrapWidth - 16)) {
                            this.entries.add(new LinkEntry((String)line, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (Object line : this.textRenderer.m_0466830(new C_1160932(key, new Object[0]).m_7551367(new C_6237110().m_0282611(C_1945050.f_7743109).m_9739860(Boolean.valueOf(true))).m_2117196(), wrapWidth - 16)) {
                            this.entries.add(new LinkEntry((String)line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    this.entries.add(emptyEntry);
                    for (Object line : this.textRenderer.m_0466830(LICENSE_TEXT.m_2117196(), wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)line));
                    }
                    for (String license : licenses) {
                        int indent = 8;
                        for (Object line : this.textRenderer.m_0466830(license, wrapWidth - 16)) {
                            this.entries.add(new DescriptionEntry((String)line, indent));
                            indent = 16;
                        }
                    }
                }
                if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
                    SortedMap<String, Set<String>> credits;
                    if ("minecraft".equals(mod.getId())) {
                        this.entries.add(emptyEntry);
                        for (Object line : this.textRenderer.m_0466830(VIEW_CREDITS_TEXT.m_2117196(), wrapWidth)) {
                            this.entries.add(new MojangCreditsEntry((String)line));
                        }
                    } else if (!"java".equals(mod.getId()) && !(credits = mod.getCredits()).isEmpty()) {
                        this.entries.add(emptyEntry);
                        for (Object line : this.textRenderer.m_0466830(CREDITS_TEXT.m_2117196(), wrapWidth)) {
                            this.entries.add(new DescriptionEntry((String)line));
                        }
                        Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
                        while (iterator.hasNext()) {
                            int indent = 8;
                            Map.Entry<String, Set<String>> role = iterator.next();
                            String roleName = role.getKey();
                            for (Object line : this.textRenderer.m_0466830(this.creditsRoleText(roleName).m_2117196(), wrapWidth - 16)) {
                                this.entries.add(new DescriptionEntry((String)line, indent));
                                indent = 16;
                            }
                            for (String contributor : role.getValue()) {
                                indent = 16;
                                for (Object line : this.textRenderer.m_0466830(new C_1716360(contributor).m_2117196(), wrapWidth - 24)) {
                                    this.entries.add(new DescriptionEntry((String)line, indent));
                                    indent = 24;
                                }
                            }
                            if (!iterator.hasNext()) continue;
                            this.entries.add(emptyEntry);
                        }
                    }
                }
            }
        }
        C_5786166 tessellator = C_5786166.m_2065116();
        C_8373595 bufferBuilder = tessellator.m_1454391();
        this.f_3511485.m_1218956().m_5325521(C_3020744.f_9745145);
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.m_7801527();
        bufferBuilder.m_3571142(32, 32, 32);
        bufferBuilder.m_7094509((double)this.f_8129586, (double)this.f_9145833, 0.0, (double)((float)this.f_8129586 / 32.0f), (double)(((float)this.f_9145833 + this.f_1867063) / 32.0f));
        bufferBuilder.m_7094509((double)this.f_7901480, (double)this.f_9145833, 0.0, (double)((float)this.f_7901480 / 32.0f), (double)(((float)this.f_9145833 + this.f_1867063) / 32.0f));
        bufferBuilder.m_7094509((double)this.f_7901480, (double)this.f_9975269, 0.0, (double)((float)this.f_7901480 / 32.0f), (double)(((float)this.f_9975269 + this.f_1867063) / 32.0f));
        bufferBuilder.m_7094509((double)this.f_8129586, (double)this.f_9975269, 0.0, (double)((float)this.f_8129586 / 32.0f), (double)(((float)this.f_9975269 + this.f_1867063) / 32.0f));
        tessellator.m_8222644();
        int listX = this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2;
        int listY = this.f_9975269 + 4 - (int)this.f_1867063;
        this.m_2972483(listX, listY, mouseX, mouseY);
        C_3754158.m_2374887((int)515);
        C_3754158.m_7027522();
        C_3754158.m_9671730();
        C_3754158.m_0833259((int)770, (int)771, (int)0, (int)1);
        C_3754158.m_6191982();
        C_3754158.m_9665853((int)7425);
        C_3754158.m_2090124();
        bufferBuilder.m_7801527();
        bufferBuilder.m_1670498(0, 0, 0, 0);
        bufferBuilder.m_7094509((double)this.f_8129586, (double)(this.f_9975269 + 4), 0.0, 0.0, 1.0);
        bufferBuilder.m_7094509((double)this.f_7901480, (double)(this.f_9975269 + 4), 0.0, 1.0, 1.0);
        bufferBuilder.m_2904966(0, 255);
        bufferBuilder.m_7094509((double)this.f_7901480, (double)this.f_9975269, 0.0, 1.0, 0.0);
        bufferBuilder.m_7094509((double)this.f_8129586, (double)this.f_9975269, 0.0, 0.0, 0.0);
        tessellator.m_8222644();
        bufferBuilder.m_7801527();
        bufferBuilder.m_1670498(0, 0, 0, 255);
        bufferBuilder.m_7094509((double)this.f_8129586, (double)this.f_9145833, 0.0, 0.0, 1.0);
        bufferBuilder.m_7094509((double)this.f_7901480, (double)this.f_9145833, 0.0, 1.0, 1.0);
        bufferBuilder.m_1670498(0, 0, 0, 0);
        bufferBuilder.m_7094509((double)this.f_7901480, (double)(this.f_9145833 - 4), 0.0, 1.0, 0.0);
        bufferBuilder.m_7094509((double)this.f_8129586, (double)(this.f_9145833 - 4), 0.0, 0.0, 0.0);
        tessellator.m_8222644();
        this.renderScrollBar(bufferBuilder, tessellator);
        C_3754158.m_7547086();
        C_3754158.m_9665853((int)7424);
        C_3754158.m_2754767();
        C_3754158.m_5313301();
    }

    protected void m_2768810(int index, int x, int y, int height, int mouseX, int mouseY) {
        if (y >= this.f_9975269 && y + height <= this.f_9145833) {
            super.m_2768810(index, x, y, height, mouseX, mouseY);
        }
    }

    public void renderScrollBar(C_8373595 bufferBuilder, C_5786166 tessellator) {
        int scrollbarStartX = this.m_3021017();
        int scrollbarEndX = scrollbarStartX + 6;
        int maxScroll = this.m_6867946();
        if (maxScroll > 0) {
            int p = (int)((float)((this.f_9145833 - this.f_9975269) * (this.f_9145833 - this.f_9975269)) / (float)this.m_6867946());
            p = C_4976084.m_1109374((int)p, (int)32, (int)(this.f_9145833 - this.f_9975269 - 8));
            int q = this.m_0467656() * (this.f_9145833 - this.f_9975269 - p) / maxScroll + this.f_9975269;
            if (q < this.f_9975269) {
                q = this.f_9975269;
            }
            bufferBuilder.m_7801527();
            bufferBuilder.m_1670498(0, 0, 0, 255);
            bufferBuilder.m_7094509((double)scrollbarStartX, (double)this.f_9145833, 0.0, 0.0, 1.0);
            bufferBuilder.m_7094509((double)scrollbarEndX, (double)this.f_9145833, 0.0, 1.0, 1.0);
            bufferBuilder.m_7094509((double)scrollbarEndX, (double)this.f_9975269, 0.0, 1.0, 0.0);
            bufferBuilder.m_7094509((double)scrollbarStartX, (double)this.f_9975269, 0.0, 0.0, 0.0);
            tessellator.m_8222644();
            bufferBuilder.m_7801527();
            bufferBuilder.m_1670498(128, 128, 128, 255);
            bufferBuilder.m_7094509((double)scrollbarStartX, (double)(q + p), 0.0, 0.0, 1.0);
            bufferBuilder.m_7094509((double)scrollbarEndX, (double)(q + p), 0.0, 1.0, 1.0);
            bufferBuilder.m_7094509((double)scrollbarEndX, (double)q, 0.0, 1.0, 0.0);
            bufferBuilder.m_7094509((double)scrollbarStartX, (double)q, 0.0, 0.0, 0.0);
            tessellator.m_8222644();
            bufferBuilder.m_7801527();
            bufferBuilder.m_1670498(192, 192, 192, 255);
            bufferBuilder.m_7094509((double)scrollbarStartX, (double)(q + p - 1), 0.0, 0.0, 1.0);
            bufferBuilder.m_7094509((double)(scrollbarEndX - 1), (double)(q + p - 1), 0.0, 1.0, 1.0);
            bufferBuilder.m_7094509((double)(scrollbarEndX - 1), (double)q, 0.0, 1.0, 0.0);
            bufferBuilder.m_7094509((double)scrollbarStartX, (double)q, 0.0, 0.0, 0.0);
            tessellator.m_8222644();
        }
    }

    public void m_7743236(boolean result, int id) {
        if (result) {
            DescriptionEntry entry;
            List<DescriptionEntry> entries = this.entries;
            if (id >= 0 && id < entries.size() && (entry = entries.get(id)) instanceof LinkEntry) {
                String link = ((LinkEntry)entry).link;
                ScreenUtil.openLink(this.parent, link, this.parent.getSelectedEntry().mod.getId() + "/link");
            }
        }
        this.f_3511485.m_6408915((C_3020744)this.parent);
    }

    private C_9550253 creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[\\s-]", "_").toLowerCase();
        return new C_1160932("modmenu.credits.role." + translationKey, new Object[0]).m_8059675((C_9550253)new C_1716360(":"));
    }

    protected class DescriptionEntry
    implements C_3784880 {
        protected String text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(String text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(String text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void m_1433237(int index, int mouseX, int mouseY) {
        }

        public void m_2013749(int index, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered) {
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(x + this.indent, y);
                x += 11;
            }
            DescriptionListWidget.this.textRenderer.m_1950885(this.text, (float)(x + this.indent), (float)y, 0xAAAAAA);
        }

        public boolean m_3739705(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            return false;
        }

        public void m_4703785(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(String text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(String text, String link) {
            this(text, link, 0);
        }

        @Override
        public boolean m_3739705(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            if (DescriptionListWidget.this.isMouseInList(mouseX, mouseY)) {
                DescriptionListWidget.this.f_3511485.m_6408915((C_3020744)new C_9468736((C_3268052)DescriptionListWidget.this, this.link, index, false));
            }
            return super.m_3739705(index, mouseX, mouseY, button, entryMouseX, entryMouseY);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(String text) {
            super(text);
        }

        @Override
        public boolean m_3739705(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            if (DescriptionListWidget.this.isMouseInList(mouseX, mouseY)) {
                DescriptionListWidget.this.f_3511485.m_6408915((C_3020744)new C_2594473());
            }
            return super.m_3739705(index, mouseX, mouseY, button, entryMouseX, entryMouseY);
        }
    }
}

