/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_3784880;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4882708;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9550253;

public class ModListEntry
implements C_3784880 {
    public static final C_0561170 UNKNOWN_ICON = new C_0561170("textures/misc/unknown_pack.png");
    private static final C_0561170 MOD_CONFIGURATION_ICON = new C_0561170("modmenu", "textures/gui/mod_configuration.png");
    private static final C_0561170 ERROR_ICON = new C_0561170("minecraft", "textures/gui/world_selection.png");
    protected final C_8105098 client;
    public final Mod mod;
    protected final ModListWidget list;
    protected C_0561170 iconLocation;
    protected static final int FULL_ICON_SIZE = 32;
    protected static final int COMPACT_ICON_SIZE = 19;
    protected long sinceLastClick;

    public ModListEntry(Mod mod, ModListWidget list) {
        this.mod = mod;
        this.list = list;
        this.client = C_8105098.m_0408063();
    }

    public void m_1433237(int index, int mouseX, int mouseY) {
    }

    public void m_2013749(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
        C_1716360 name;
        x += this.getXOffset();
        rowWidth -= this.getXOffset();
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        String modId = this.mod.getId();
        if ("java".equals(modId)) {
            DrawingUtil.drawRandomVersionBackground(this.mod, x, y, iconSize, iconSize);
        }
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        C_3754158.m_9671730();
        this.client.m_1218956().m_5325521(this.getIconTexture());
        C_2691939.m_5935491((int)x, (int)y, (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (float)iconSize, (float)iconSize);
        C_3754158.m_5313301();
        C_1716360 trimmedName = name = new C_1716360(this.mod.getTranslatedName());
        int maxNameWidth = rowWidth - iconSize - 3;
        C_3831727 font = this.client.f_0426313;
        if (font.m_0040387(name.m_2117196()) > maxNameWidth) {
            C_1716360 ellipsis = new C_1716360("...");
            trimmedName = new C_1716360("").m_1643573(font.m_3198719(name.m_2117196(), maxNameWidth - font.m_0040387(ellipsis.m_2117196()))).m_8059675((C_9550253)ellipsis);
        }
        font.m_4683674(trimmedName.m_2117196(), x + iconSize + 3, y + 1, 0xFFFFFF);
        int updateBadgeXOffset = 0;
        if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(modId) && (this.mod.hasUpdate() || this.mod.getChildHasUpdate())) {
            UpdateAvailableBadge.renderBadge(x + iconSize + 3 + font.m_0040387(name.m_2117196()) + 2, y);
            updateBadgeXOffset = 11;
        }
        if (!ModMenuConfig.HIDE_BADGES.getValue()) {
            new ModBadgeRenderer(x + iconSize + 3 + font.m_0040387(name.m_2117196()) + 2 + updateBadgeXOffset, y, x + rowWidth, this.mod, this.list.getParent()).draw(mouseX, mouseY);
        }
        if (!ModMenuConfig.COMPACT_LIST.getValue()) {
            String summary = this.mod.getSummary();
            DrawingUtil.drawWrappedString(summary, x + iconSize + 3 + 4, y + this.client.f_0426313.f_6725889 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        } else {
            DrawingUtil.drawWrappedString(this.mod.getPrefixedVersion(), x + iconSize + 3, y + this.client.f_0426313.f_6725889 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        }
        if (!(this instanceof ParentEntry) && ModMenuConfig.QUICK_CONFIGURE.getValue() && (this.list.getParent().getModHasConfigScreen().get(modId).booleanValue() || this.list.getParent().modScreenErrors.containsKey(modId))) {
            int textureSize;
            int n = textureSize = ModMenuConfig.COMPACT_LIST.getValue() ? 152 : 256;
            if (this.client.f_9967940.f_6270799 || hovered) {
                int v;
                C_2691939.m_7865719((int)x, (int)y, (int)(x + iconSize), (int)(y + iconSize), (int)-1601138544);
                boolean hoveringIcon = mouseX - x < iconSize;
                int n2 = v = hoveringIcon ? iconSize : 0;
                if (this.list.getParent().modScreenErrors.containsKey(modId)) {
                    this.client.m_1218956().m_5325521(ERROR_ICON);
                    C_2691939.m_5935491((int)x, (int)y, (float)96.0f, (float)v, (int)iconSize, (int)iconSize, (float)textureSize, (float)textureSize);
                    if (hoveringIcon) {
                        Throwable e = this.list.getParent().modScreenErrors.get(modId);
                        this.list.getParent().setTooltip(this.client.f_0426313.m_0466830(new C_1160932("modmenu.configure.error", new Object[]{modId, modId}).m_1643573("\n\n").m_1643573(e.toString()).m_7551367(new C_6237110().m_0282611(C_1945050.f_9213701)).m_2117196(), 175));
                    }
                } else {
                    this.client.m_1218956().m_5325521(MOD_CONFIGURATION_ICON);
                    C_2691939.m_5935491((int)x, (int)y, (float)0.0f, (float)v, (int)iconSize, (int)iconSize, (float)textureSize, (float)textureSize);
                }
            }
        }
    }

    public boolean m_3739705(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
        this.list.select(this);
        if (ModMenuConfig.QUICK_CONFIGURE.getValue() && this.list.getParent().getModHasConfigScreen().get(this.mod.getId()).booleanValue()) {
            int iconSize;
            int n = iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
            if (mouseX - this.list.getRowLeft() <= iconSize) {
                this.openConfig();
            } else if (C_8105098.m_6224581() - this.sinceLastClick < 250L) {
                this.openConfig();
            }
        }
        this.sinceLastClick = C_8105098.m_6224581();
        return true;
    }

    public void m_4703785(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
    }

    public boolean keyPressed(char chr, int key) {
        return false;
    }

    public void openConfig() {
        this.client.m_6408915(ModMenu.getConfigScreen(this.mod.getId(), this.list.getParent()));
    }

    public Mod getMod() {
        return this.mod;
    }

    public C_0561170 getIconTexture() {
        if (this.iconLocation == null) {
            this.iconLocation = new C_0561170("modmenu", this.mod.getId() + "_icon");
            C_3779718 icon = this.mod.getIcon(this.list.getFabricIconHandler(), 64 * this.client.f_9967940.f_7306555);
            if (icon != null) {
                this.client.m_1218956().m_0381205(this.iconLocation, (C_4882708)icon);
            } else {
                this.iconLocation = UNKNOWN_ICON;
            }
        }
        return this.iconLocation;
    }

    public int getXOffset() {
        return 0;
    }
}

