/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu;

import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.event.ModMenuEventHandler;
import com.terraformersmc.modmenu.util.UpdateCheckerUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricDummyParentMod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricMod;
import com.terraformersmc.modmenu.util.mod.quilt.QuiltMod;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_9550253;
import net.ornithemc.osl.entrypoints.api.client.ClientModInitializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModMenu
implements ClientModInitializer {
    public static final String MOD_ID = "modmenu";
    public static final String GITHUB_REF = "OrnitheMC/ModMenu";
    public static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu");
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    public static final Gson GSON_MINIFIED = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    public static final Map<String, Mod> MODS = new HashMap<String, Mod>();
    public static final Map<String, Mod> ROOT_MODS = new HashMap<String, Mod>();
    public static final LinkedListMultimap<Mod, Mod> PARENT_MAP = LinkedListMultimap.create();
    private static final Map<String, ConfigScreenFactory<?>> configScreenFactories = new HashMap();
    private static final List<ModMenuApi> apiImplementations = new ArrayList<ModMenuApi>();
    private static int cachedDisplayedModCount = -1;
    public static boolean runningQuilt = FabricLoader.getInstance().isModLoaded("quilt_loader");
    public static boolean devEnvironment = FabricLoader.getInstance().isDevelopmentEnvironment();

    public static C_3020744 getConfigScreen(String modid, C_3020744 menuScreen) {
        for (ModMenuApi api : apiImplementations) {
            Map<String, ConfigScreenFactory<?>> factoryProviders = api.getProvidedConfigScreenFactories();
            if (factoryProviders.isEmpty()) continue;
            factoryProviders.forEach(configScreenFactories::putIfAbsent);
        }
        if (ModMenuConfig.HIDDEN_CONFIGS.getValue().contains(modid)) {
            return null;
        }
        ConfigScreenFactory<?> factory = configScreenFactories.get(modid);
        if (factory != null) {
            return factory.create(menuScreen);
        }
        return null;
    }

    public void initClient() {
        ModMenuConfigManager.initializeConfig();
        HashSet<String> modpackMods = new HashSet<String>();
        HashMap updateCheckers = new HashMap();
        HashMap providedUpdateCheckers = new HashMap();
        FabricLoader.getInstance().getEntrypointContainers(MOD_ID, ModMenuApi.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                ModMenuApi api = (ModMenuApi)entrypoint.getEntrypoint();
                configScreenFactories.put(modId, api.getModConfigScreenFactory());
                apiImplementations.add(api);
                updateCheckers.put(modId, api.getUpdateChecker());
                providedUpdateCheckers.putAll(api.getProvidedUpdateCheckers());
                api.attachModpackBadges(modpackMods::add);
            }
            catch (Throwable e) {
                LOGGER.error("Mod {} provides a broken implementation of ModMenuApi", (Object)modId, (Object)e);
            }
        });
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            Mod mod = runningQuilt ? new QuiltMod(modContainer, modpackMods) : new FabricMod(modContainer, modpackMods);
            UpdateChecker updateChecker = (UpdateChecker)updateCheckers.get(mod.getId());
            if (updateChecker == null) {
                updateChecker = (UpdateChecker)providedUpdateCheckers.get(mod.getId());
            }
            MODS.put(mod.getId(), mod);
            mod.setUpdateChecker(updateChecker);
        }
        ModMenu.checkForUpdates();
        HashMap<String, Mod> dummyParents = new HashMap<String, Mod>();
        for (Mod mod : MODS.values()) {
            String parentId = mod.getParent();
            if (parentId != null) {
                Mod parent = MODS.getOrDefault(parentId, (Mod)dummyParents.get(parentId));
                if (parent == null && mod instanceof FabricMod) {
                    parent = new FabricDummyParentMod((FabricMod)mod, parentId);
                    dummyParents.put(parentId, parent);
                }
                PARENT_MAP.put((Object)parent, (Object)mod);
                continue;
            }
            ROOT_MODS.put(mod.getId(), mod);
        }
        MODS.putAll(dummyParents);
        ModMenuEventHandler.register();
    }

    public static void clearModCountCache() {
        cachedDisplayedModCount = -1;
    }

    public static void checkForUpdates() {
        UpdateCheckerUtil.checkForUpdates();
    }

    public static boolean areModUpdatesAvailable() {
        if (!ModMenuConfig.UPDATE_CHECKER.getValue()) {
            return false;
        }
        for (Mod mod : MODS.values()) {
            if (mod.isHidden() || !ModMenuConfig.SHOW_LIBRARIES.getValue() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || !mod.hasUpdate() && !mod.getChildHasUpdate()) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayedModCount() {
        if (cachedDisplayedModCount == -1) {
            cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod -> !(!ModMenuConfig.COUNT_CHILDREN.getValue() && mod.getParent() != null || !ModMenuConfig.COUNT_LIBRARIES.getValue() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || !ModMenuConfig.COUNT_HIDDEN_MODS.getValue() && mod.isHidden())).count());
        }
        return NumberFormat.getInstance().format(cachedDisplayedModCount);
    }

    public static C_9550253 createModsButtonText(boolean title) {
        boolean isIcon;
        ModMenuConfig.TitleMenuButtonStyle titleStyle = ModMenuConfig.MODS_BUTTON_STYLE.getValue();
        ModMenuConfig.GameMenuButtonStyle gameMenuStyle = ModMenuConfig.GAME_MENU_BUTTON_STYLE.getValue();
        boolean bl = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.ICON : (isIcon = gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.ICON);
        boolean isShort = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.SHRINK : false;
        C_1160932 modsText = new C_1160932("modmenu.title", new Object[0]);
        if (ModMenuConfig.MOD_COUNT_LOCATION.getValue().isOnModsButton() && !isIcon) {
            String count = ModMenu.getDisplayedModCount();
            if (isShort) {
                modsText.m_8059675((C_9550253)new C_1716360(" ")).m_8059675((C_9550253)new C_1160932("modmenu.loaded.short", new Object[]{count}));
            } else {
                String key;
                String specificKey = "modmenu.loaded." + count;
                String string = key = C_3390001.m_4886719((String)specificKey) ? specificKey : "modmenu.loaded";
                if (ModMenuConfig.EASTER_EGGS.getValue() && C_3390001.m_4886719((String)(specificKey + ".secret"))) {
                    key = specificKey + ".secret";
                }
                modsText.m_8059675((C_9550253)new C_1716360(" ")).m_8059675((C_9550253)new C_1160932(key, new Object[]{count}));
            }
        }
        return modsText;
    }
}

