/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config.option;

import com.terraformersmc.modmenu.config.option.ConfigOption;
import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.util.TranslationUtil;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_9550253;

public class BooleanConfigOption
implements ConfigOption {
    private final String key;
    private final String translationKey;
    private final boolean defaultValue;
    private final C_9550253 enabledText;
    private final C_9550253 disabledText;

    public BooleanConfigOption(String key, boolean defaultValue, String enabledKey, String disabledKey) {
        ConfigOptionStorage.setBoolean(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.defaultValue = defaultValue;
        this.enabledText = new C_1160932(this.translationKey + "." + enabledKey, new Object[0]);
        this.disabledText = new C_1160932(this.translationKey + "." + disabledKey, new Object[0]);
    }

    public BooleanConfigOption(String key, boolean defaultValue) {
        this(key, defaultValue, "true", "false");
    }

    public String getKey() {
        return this.key;
    }

    public boolean getValue() {
        return ConfigOptionStorage.getBoolean(this.key);
    }

    public void setValue(boolean value) {
        ConfigOptionStorage.setBoolean(this.key, value);
    }

    public void toggleValue() {
        ConfigOptionStorage.toggleBoolean(this.key);
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getValueLabel() {
        return TranslationUtil.translateOptionLabel((C_9550253)new C_1160932(this.translationKey, new Object[0]), this.getValue() ? this.enabledText : this.disabledText);
    }

    @Override
    public void click() {
        this.toggleValue();
    }
}

