/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui;

import com.google.common.base.Joiner;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.gui.widget.DescriptionListWidget;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.TexturedButtonWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.TranslationUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0614482;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_2925725;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3268052;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_9468736;
import net.minecraft.unmapped.C_9550253;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModsScreen
extends C_3020744 {
    private static final C_0561170 FILTERS_BUTTON_LOCATION = new C_0561170("modmenu", "textures/gui/filters_button.png");
    private static final C_0561170 CONFIGURE_BUTTON_LOCATION = new C_0561170("modmenu", "textures/gui/configure_button.png");
    private static final int SEARCH_BOX = 0;
    private static final int DESCRIPTION_LIST = 1;
    private static final int WEBSITE = 2;
    private static final int ISSUES = 3;
    private static final int FILTERS = 4;
    private static final int SORTING = 5;
    private static final int LIBRARIES = 6;
    private static final int MODS_FOLDER = 7;
    private static final int DONE = 8;
    private static final C_9550253 TOGGLE_FILTER_OPTIONS = new C_1160932("modmenu.toggleFilterOptions", new Object[0]);
    private static final C_9550253 CONFIGURE = new C_1160932("modmenu.configure", new Object[0]);
    private static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu | ModsScreen");
    private C_2925725 searchBox;
    private DescriptionListWidget descriptionListWidget;
    private final C_9550253 title;
    private final C_3020744 previousScreen;
    private ModListWidget modList;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private double scrollPercent = 0.0;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private static final int RIGHT_PANE_Y = 48;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    private int mouseX;
    private int mouseY;
    private List<String> tooltip;
    public final Map<String, Boolean> modHasConfigScreen = new HashMap<String, Boolean>();
    public final Map<String, Throwable> modScreenErrors = new HashMap<String, Throwable>();

    public ModsScreen(C_3020744 previousScreen) {
        this.title = new C_1160932("modmenu.title", new Object[0]);
        this.previousScreen = previousScreen;
    }

    public boolean mouseScrolled(double amount) {
        if (this.modList.m_5752726(this.mouseX, this.mouseY)) {
            return this.modList.mouseScrolled(amount);
        }
        if (this.descriptionListWidget.m_5752726(this.mouseX, this.mouseY)) {
            return this.descriptionListWidget.mouseScrolled(amount);
        }
        return false;
    }

    public void m_2450377() {
        this.searchBox.m_0296611();
    }

    protected void m_3593494() {
        this.paneY = ModMenuConfig.CONFIG_MODE.getValue() ? 48 : 67;
        this.paneWidth = this.f_5465691 / 2 - 8;
        this.rightPaneX = this.f_5465691 - this.paneWidth;
        int filtersButtonSize = ModMenuConfig.CONFIG_MODE.getValue() ? 0 : 22;
        int searchWidthMax = this.paneWidth - 32 - filtersButtonSize;
        int searchBoxWidth = ModMenuConfig.CONFIG_MODE.getValue() ? Math.min(200, searchWidthMax) : searchWidthMax;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
        this.searchBox = new C_2925725(0, this.f_2020658, this.searchBoxX, 22, searchBoxWidth, 20);
        this.searchBox.m_6763105(C_3390001.m_2053009((String)"modmenu.search", (Object[])new Object[0]));
        this.searchBox.m_8176952((id, text) -> this.modList.filter((String)text, false));
        for (Mod mod : ModMenu.MODS.values()) {
            String id2 = mod.getId();
            if (this.modHasConfigScreen.containsKey(id2)) continue;
            try {
                C_3020744 configScreen = ModMenu.getConfigScreen(id2, this);
                this.modHasConfigScreen.put(id2, configScreen != null);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warn("The '" + id2 + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
                this.modScreenErrors.put(id2, e);
                this.modHasConfigScreen.put(id2, false);
            }
            catch (Throwable e) {
                LOGGER.error("Error from mod '" + id2 + "'", e);
                this.modScreenErrors.put(id2, e);
                this.modHasConfigScreen.put(id2, false);
            }
        }
        this.modList = new ModListWidget(this.f_7153641, this.paneWidth, this.f_3080061, this.paneY, this.f_3080061 - 36, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.searchBox.m_4862541(), this.modList, this);
        this.modList.m_3867153(0);
        this.modList.reloadFilters();
        this.descriptionListWidget = new DescriptionListWidget(this.f_7153641, this.paneWidth, this.f_3080061, 108, this.f_3080061 - 36, this.f_2020658.f_9212522 + 1, this);
        this.descriptionListWidget.m_3867153(this.rightPaneX);
        TexturedButtonWidget configureButton = new TexturedButtonWidget(1, this.f_5465691 - 24, 48, 20, 20, 0, 0, 20, CONFIGURE_BUTTON_LOCATION, 32, 64){
            private C_9550253 tooltip;

            public void m_9319498(double d, double e) {
                String id = Objects.requireNonNull(ModsScreen.this.selected).getMod().getId();
                if (ModsScreen.this.modHasConfigScreen.get(id).booleanValue()) {
                    C_3020744 configScreen = ModMenu.getConfigScreen(id, ModsScreen.this);
                    ModsScreen.this.f_7153641.m_6408915(configScreen);
                } else {
                    this.f_3831222 = false;
                }
            }

            @Override
            public void m_5350167(int mouseX, int mouseY, float delta) {
                String modId = ModsScreen.this.selected.getMod().getId();
                if (ModsScreen.this.selected != null) {
                    this.f_3831222 = ModsScreen.this.modHasConfigScreen.get(modId);
                } else {
                    this.f_3831222 = false;
                    this.f_1990467 = false;
                }
                boolean bl = this.f_1990467 = ModsScreen.this.selected != null && ModsScreen.this.modHasConfigScreen.get(modId) != false || ModsScreen.this.modScreenErrors.containsKey(modId);
                if (ModsScreen.this.modScreenErrors.containsKey(modId)) {
                    Throwable e = ModsScreen.this.modScreenErrors.get(modId);
                    this.tooltip = new C_1160932("modmenu.configure.error", new Object[]{modId, modId}).m_5859385().m_1643573("\n\n").m_1643573(e.toString()).m_5785639(C_1945050.f_9213701);
                } else {
                    this.tooltip = CONFIGURE;
                }
                super.m_5350167(mouseX, mouseY, delta);
            }

            public void m_2016731(int mouseX, int mouseY) {
                ModsScreen.this.m_5774293(this.tooltip.m_2400023(), mouseX, mouseY);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        C_2348249 websiteButton = new C_2348249(2, this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, 84, Math.min(urlButtonWidths, 200), 20, C_3390001.m_2053009((String)"modmenu.website", (Object[])new Object[0])){

            public void m_9319498(double d, double e) {
                Mod mod = Objects.requireNonNull(ModsScreen.this.selected).getMod();
                ModsScreen.this.f_7153641.m_6408915((C_3020744)new C_9468736((C_3268052)ModsScreen.this, ((ModsScreen)ModsScreen.this).selected.mod.getWebsite(), 2, false));
            }

            public void m_5350167(int mouseX, int mouseY, float delta) {
                this.f_1990467 = ModsScreen.this.selected != null;
                this.f_3831222 = this.f_1990467 && ModsScreen.this.selected.getMod().getWebsite() != null;
                super.m_5350167(mouseX, mouseY, delta);
            }
        };
        C_2348249 issuesButton = new C_2348249(3, this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, 84, Math.min(urlButtonWidths, 200), 20, C_3390001.m_2053009((String)"modmenu.issues", (Object[])new Object[0])){

            public void m_9319498(double d, double e) {
                Mod mod = Objects.requireNonNull(ModsScreen.this.selected).getMod();
                ModsScreen.this.f_7153641.m_6408915((C_3020744)new C_9468736((C_3268052)ModsScreen.this, ((ModsScreen)ModsScreen.this).selected.mod.getIssueTracker(), 3, false));
            }

            public void m_5350167(int mouseX, int mouseY, float delta) {
                this.f_1990467 = ModsScreen.this.selected != null;
                this.f_3831222 = this.f_1990467 && ModsScreen.this.selected.getMod().getIssueTracker() != null;
                super.m_5350167(mouseX, mouseY, delta);
            }
        };
        this.f_0046022.add(this.searchBox);
        TexturedButtonWidget filtersButton = new TexturedButtonWidget(4, this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, 20, FILTERS_BUTTON_LOCATION, 32, 64){

            public void m_9319498(double d, double e) {
                ModsScreen.this.filterOptionsShown = !ModsScreen.this.filterOptionsShown;
            }

            public void m_2016731(int mouseX, int mouseY) {
                ModsScreen.this.m_5774293(TOGGLE_FILTER_OPTIONS.m_2400023(), mouseX, mouseY);
            }
        };
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            this.m_1572243(filtersButton);
        }
        String showLibrariesText = ModMenuConfig.SHOW_LIBRARIES.getValueLabel();
        String sortingText = ModMenuConfig.SORTING.getValueLabel();
        int showLibrariesWidth = this.f_2020658.m_5191771(showLibrariesText) + 20;
        int sortingWidth = this.f_2020658.m_5191771(sortingText) + 20;
        this.filtersWidth = showLibrariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        this.m_1572243(new C_2348249(5, this.filtersX, 45, sortingWidth, 20, sortingText){

            public void m_9319498(double d, double e) {
                ModMenuConfig.SORTING.cycleValue();
                ModMenuConfigManager.save();
                ModsScreen.this.modList.reloadFilters();
            }

            public void m_5350167(int mouseX, int mouseY, float delta) {
                this.f_1990467 = ModsScreen.this.filterOptionsShown;
                this.f_4865617 = ModMenuConfig.SORTING.getValueLabel();
                super.m_5350167(mouseX, mouseY, delta);
            }
        });
        this.m_1572243(new C_2348249(6, this.filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText){

            public void m_9319498(double d, double e) {
                ModMenuConfig.SHOW_LIBRARIES.toggleValue();
                ModMenuConfigManager.save();
                ModsScreen.this.modList.reloadFilters();
            }

            public void m_5350167(int mouseX, int mouseY, float delta) {
                this.f_1990467 = ModsScreen.this.filterOptionsShown;
                this.f_4865617 = ModMenuConfig.SHOW_LIBRARIES.getValueLabel();
                super.m_5350167(mouseX, mouseY, delta);
            }
        });
        this.f_0046022.add(this.modList);
        if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
            this.m_1572243(configureButton);
        }
        this.m_1572243(websiteButton);
        this.m_1572243(issuesButton);
        this.f_0046022.add(this.descriptionListWidget);
        this.m_1572243(new C_2348249(7, this.f_5465691 / 2 - 154, this.f_3080061 - 28, 150, 20, C_3390001.m_2053009((String)"modmenu.modsFolder", (Object[])new Object[0])){

            public void m_9319498(double d, double e) {
                C_0614482.m_0461844().m_7639523(new File(FabricLoader.getInstance().getGameDir().toFile(), "mods"));
            }
        });
        this.m_1572243(new C_2348249(8, this.f_5465691 / 2 + 4, this.f_3080061 - 28, 150, 20, C_3390001.m_2053009((String)"gui.done", (Object[])new Object[0])){

            public void m_9319498(double d, double e) {
                ModsScreen.this.f_7153641.m_6408915(ModsScreen.this.previousScreen);
            }
        });
        this.searchBox.m_2785860(true);
        this.init = true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers) || this.searchBox.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char chr, int keyCode) {
        return this.searchBox.charTyped(chr, keyCode);
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tooltip = null;
        this.m_7817195();
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.m_9734698(mouseX, mouseY, delta);
        }
        this.modList.m_9734698(mouseX, mouseY, delta);
        this.searchBox.m_1620442(mouseX, mouseY, delta);
        C_3754158.m_5313301();
        this.m_2717572(this.f_2020658, this.title.m_2400023(), this.modList.getWidth() / 2, 8, 0xFFFFFF);
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            C_9550253 fullModCount = this.computeModCountText(true);
            if (!ModMenuConfig.CONFIG_MODE.getValue() && this.updateFiltersX()) {
                if (this.filterOptionsShown) {
                    if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.f_2020658.m_5191771(fullModCount.m_2400023()) <= this.filtersX - 5) {
                        this.f_2020658.m_8287709(fullModCount.m_2400023(), (float)this.searchBoxX, 52.0f, 0xFFFFFF);
                    } else {
                        this.f_2020658.m_8287709(this.computeModCountText(false).m_2400023(), (float)this.searchBoxX, 46.0f, 0xFFFFFF);
                        this.f_2020658.m_8287709(this.computeLibraryCountText().m_2400023(), (float)this.searchBoxX, 57.0f, 0xFFFFFF);
                    }
                } else if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.f_2020658.m_5191771(fullModCount.m_2400023()) <= this.modList.getWidth() - 5) {
                    this.f_2020658.m_8287709(fullModCount.m_2400023(), (float)this.searchBoxX, 52.0f, 0xFFFFFF);
                } else {
                    this.f_2020658.m_8287709(this.computeModCountText(false).m_2400023(), (float)this.searchBoxX, 46.0f, 0xFFFFFF);
                    this.f_2020658.m_8287709(this.computeLibraryCountText().m_2400023(), (float)this.searchBoxX, 57.0f, 0xFFFFFF);
                }
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            C_1716360 name;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, x, 48, 32, 32);
            }
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            C_3754158.m_9671730();
            this.f_7153641.m_1218956().m_5325521(this.selected.getIconTexture());
            C_2691939.m_5935491((int)x, (int)48, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
            C_3754158.m_5313301();
            int lineSpacing = this.f_2020658.f_9212522 + 1;
            int imageOffset = 36;
            C_1716360 trimmedName = name = new C_1716360(mod.getTranslatedName());
            int maxNameWidth = this.f_5465691 - (x + imageOffset);
            if (this.f_2020658.m_5191771(name.m_2400023()) > maxNameWidth) {
                C_1716360 ellipsis = new C_1716360("...");
                trimmedName = new C_1716360("").m_1643573(this.f_2020658.m_9143478(name.m_2400023(), maxNameWidth - this.f_2020658.m_5191771(ellipsis.m_2400023()))).m_8059675((C_9550253)ellipsis);
            }
            this.f_2020658.m_8287709(trimmedName.m_2400023(), (float)(x + imageOffset), 49.0f, 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > 49 && mouseY < 49 + this.f_2020658.f_9212522 && mouseX < x + imageOffset + this.f_2020658.m_5191771(trimmedName.m_2400023())) {
                this.setTooltip(Arrays.asList(C_3390001.m_2053009((String)"modmenu.modIdToolTip", (Object[])new Object[]{mod.getId()})));
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.f_7153641.f_0426313.m_5191771(trimmedName.m_2400023()) + 2, 48, this.f_5465691 - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!ModMenuConfig.HIDE_BADGES.getValue()) {
                this.modBadgeRenderer.draw(mouseX, mouseY);
            }
            if (mod.isReal()) {
                this.f_2020658.m_8287709(mod.getPrefixedVersion(), (float)(x + imageOffset), (float)(50 + lineSpacing), 0x808080);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.get(0);
                DrawingUtil.drawWrappedString(C_3390001.m_2053009((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, 50 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
        super.m_7261014(mouseX, mouseY, delta);
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            this.m_9128141(this.tooltip, mouseX, mouseY);
        }
    }

    private C_9550253 computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
        if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private C_9550253 computeLibraryCountText() {
        if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return new C_1716360(null);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void m_4858913() {
        this.modList.close();
        this.f_7153641.m_6408915(this.previousScreen);
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.m_4862541();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.f_2020658.m_5191771(this.computeModCountText(true).m_2400023()) + 20 >= this.searchRowWidth && (this.filtersWidth + this.f_2020658.m_5191771(this.computeModCountText(false).m_2400023()) + 20 >= this.searchRowWidth || this.filtersWidth + this.f_2020658.m_5191771(this.computeLibraryCountText().m_2400023()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    private static boolean isFabricMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("fabric.mod.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public Map<String, Boolean> getModHasConfigScreen() {
        return this.modHasConfigScreen;
    }

    public void confirmResult(boolean result, int id) {
        if (result && this.selected != null) {
            switch (id) {
                case 2: {
                    C_0614482.m_0461844().m_5892690(this.selected.mod.getWebsite());
                    break;
                }
                case 3: {
                    C_0614482.m_0461844().m_5892690(this.selected.mod.getIssueTracker());
                }
            }
        }
        this.f_7153641.m_6408915((C_3020744)this);
    }
}

