/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.unmapped.C_0614482;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2594473;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3268052;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4399780;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import net.minecraft.unmapped.C_9468736;
import net.minecraft.unmapped.C_9550253;

public class DescriptionListWidget
extends C_1630332<DescriptionEntry>
implements C_3268052 {
    private static final C_9550253 HAS_UPDATE_TEXT = new C_1160932("modmenu.hasUpdate", new Object[0]);
    private static final C_9550253 EXPERIMENTAL_TEXT = new C_1160932("modmenu.experimental", new Object[0]).m_5785639(C_1945050.f_0313642);
    private static final C_9550253 DOWNLOAD_TEXT = new C_1160932("modmenu.downloadLink", new Object[0]).m_3094880(new C_1945050[]{C_1945050.f_7743109, C_1945050.f_0689059});
    private static final C_9550253 CHILD_HAS_UPDATE_TEXT = new C_1160932("modmenu.childHasUpdate", new Object[0]);
    private static final C_9550253 LINKS_TEXT = new C_1160932("modmenu.links", new Object[0]);
    private static final C_9550253 SOURCE_TEXT = new C_1160932("modmenu.source", new Object[0]).m_5785639(C_1945050.f_7743109).m_5785639(C_1945050.f_0689059);
    private static final C_9550253 LICENSE_TEXT = new C_1160932("modmenu.license", new Object[0]);
    private static final C_9550253 VIEW_CREDITS_TEXT = new C_1160932("modmenu.viewCredits", new Object[0]).m_5785639(C_1945050.f_7743109).m_5785639(C_1945050.f_0689059);
    private static final C_9550253 CREDITS_TEXT = new C_1160932("modmenu.credits", new Object[0]);
    private final ModsScreen parent;
    private final C_4399780 textRenderer;
    private ModListEntry lastSelected = null;

    public DescriptionListWidget(C_8105098 client, int width, int height, int top, int bottom, int entryHeight, ModsScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.parent = parent;
        this.textRenderer = client.f_0426313;
    }

    public int m_6519286() {
        return this.f_2695432 - 10;
    }

    protected int m_3021017() {
        return this.f_2695432 - 6 + this.f_8129586;
    }

    public void m_9734698(int mouseX, int mouseY, float delta) {
        this.m_7189774();
        ModListEntry selectedEntry = this.parent.getSelectedEntry();
        if (selectedEntry != this.lastSelected) {
            this.lastSelected = selectedEntry;
            this.m_6294367();
            if (this.lastSelected != null) {
                DescriptionEntry emptyEntry = new DescriptionEntry("");
                int wrapWidth = this.m_6519286() - 5;
                Mod mod = this.lastSelected.getMod();
                String description = mod.getTranslatedDescription();
                if (!description.isEmpty()) {
                    for (String line : this.textRenderer.m_3501277(description.replaceAll("\n", "\n\n"), wrapWidth)) {
                        this.m_6789466().add(new DescriptionEntry(line));
                    }
                }
                if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(mod.getId())) {
                    Object entry;
                    UpdateInfo updateInfo = mod.getUpdateInfo();
                    if (updateInfo != null && updateInfo.isUpdateAvailable()) {
                        this.m_6789466().add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.m_3501277(HAS_UPDATE_TEXT.m_2400023(), wrapWidth - 11)) {
                            entry = new DescriptionEntry((String)line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.m_6789466().add(entry);
                            ++index;
                        }
                        for (Object line : this.textRenderer.m_3501277(EXPERIMENTAL_TEXT.m_2400023(), wrapWidth - 16)) {
                            this.m_6789466().add(new DescriptionEntry((String)line, 8));
                        }
                        C_9550253 updateMessage = updateInfo.getUpdateMessage();
                        String downloadLink = updateInfo.getDownloadLink();
                        if (updateMessage == null) {
                            updateMessage = DOWNLOAD_TEXT;
                        } else if (downloadLink != null) {
                            updateMessage = updateMessage.m_6415269().m_3094880(new C_1945050[]{C_1945050.f_7743109, C_1945050.f_0689059});
                        }
                        for (String line : this.textRenderer.m_3501277(updateMessage.m_2400023(), wrapWidth - 16)) {
                            if (downloadLink != null) {
                                this.m_6789466().add(new LinkEntry(line, downloadLink, 8));
                                continue;
                            }
                            this.m_6789466().add(new DescriptionEntry(line, 8));
                        }
                    }
                    if (mod.getChildHasUpdate()) {
                        this.m_6789466().add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.m_3501277(CHILD_HAS_UPDATE_TEXT.m_2400023(), wrapWidth - 11)) {
                            entry = new DescriptionEntry((String)line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.m_6789466().add(entry);
                            ++index;
                        }
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                    this.m_6789466().add(emptyEntry);
                    for (Object line : this.textRenderer.m_3501277(LINKS_TEXT.m_2400023(), wrapWidth)) {
                        this.m_6789466().add(new DescriptionEntry((String)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object line : this.textRenderer.m_3501277(SOURCE_TEXT.m_2400023(), wrapWidth - 16)) {
                            this.m_6789466().add(new LinkEntry((String)line, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (String line : this.textRenderer.m_3501277(new C_1160932(key, new Object[0]).m_5785639(C_1945050.f_7743109).m_5785639(C_1945050.f_0689059).m_2400023(), wrapWidth - 16)) {
                            this.m_6789466().add(new LinkEntry(line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    this.m_6789466().add(emptyEntry);
                    for (Object line : this.textRenderer.m_3501277(LICENSE_TEXT.m_2400023(), wrapWidth)) {
                        this.m_6789466().add(new DescriptionEntry((String)line));
                    }
                    for (String license : licenses) {
                        int indent = 8;
                        for (String line : this.textRenderer.m_3501277(license, wrapWidth - 16)) {
                            this.m_6789466().add(new DescriptionEntry(line, indent));
                            indent = 16;
                        }
                    }
                }
                if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
                    SortedMap<String, Set<String>> credits;
                    if ("minecraft".equals(mod.getId())) {
                        this.m_6789466().add(emptyEntry);
                        for (Object line : this.textRenderer.m_3501277(VIEW_CREDITS_TEXT.m_2400023(), wrapWidth)) {
                            this.m_6789466().add(new MojangCreditsEntry((String)line));
                        }
                    } else if (!"java".equals(mod.getId()) && !(credits = mod.getCredits()).isEmpty()) {
                        this.m_6789466().add(emptyEntry);
                        for (String line : this.textRenderer.m_3501277(CREDITS_TEXT.m_2400023(), wrapWidth)) {
                            this.m_6789466().add(new DescriptionEntry(line));
                        }
                        Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
                        while (iterator.hasNext()) {
                            int indent = 8;
                            Map.Entry<String, Set<String>> role = iterator.next();
                            String roleName = role.getKey();
                            for (String line : this.textRenderer.m_3501277(this.creditsRoleText(roleName).m_2400023(), wrapWidth - 16)) {
                                this.m_6789466().add(new DescriptionEntry(line, indent));
                                indent = 16;
                            }
                            for (String contributor : role.getValue()) {
                                indent = 16;
                                for (String line : this.textRenderer.m_3501277(new C_1716360(contributor).m_2400023(), wrapWidth - 24)) {
                                    this.m_6789466().add(new DescriptionEntry(line, indent));
                                    indent = 24;
                                }
                            }
                            if (!iterator.hasNext()) continue;
                            this.m_6789466().add(emptyEntry);
                        }
                    }
                }
            }
        }
        C_5786166 tessellator = C_5786166.m_2065116();
        C_8373595 bufferBuilder = tessellator.m_1454391();
        this.f_3511485.m_1218956().m_5325521(C_3020744.f_9745145);
        C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.m_0421390(7, C_4461663.f_4312108);
        bufferBuilder.m_3299851((double)this.f_8129586, (double)this.f_9145833, 0.0).m_4749889((double)((float)this.f_8129586 / 32.0f), (double)((float)(this.f_9145833 + this.m_0467656()) / 32.0f)).m_9724942(32, 32, 32, 255).m_4365807();
        bufferBuilder.m_3299851((double)this.f_7901480, (double)this.f_9145833, 0.0).m_4749889((double)((float)this.f_7901480 / 32.0f), (double)((float)(this.f_9145833 + this.m_0467656()) / 32.0f)).m_9724942(32, 32, 32, 255).m_4365807();
        bufferBuilder.m_3299851((double)this.f_7901480, (double)this.f_9975269, 0.0).m_4749889((double)((float)this.f_7901480 / 32.0f), (double)((float)(this.f_9975269 + this.m_0467656()) / 32.0f)).m_9724942(32, 32, 32, 255).m_4365807();
        bufferBuilder.m_3299851((double)this.f_8129586, (double)this.f_9975269, 0.0).m_4749889((double)((float)this.f_8129586 / 32.0f), (double)((float)(this.f_9975269 + this.m_0467656()) / 32.0f)).m_9724942(32, 32, 32, 255).m_4365807();
        tessellator.m_8222644();
        int listX = this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2;
        int listY = this.f_9975269 + 4 - (int)this.f_1867063;
        this.m_2972483(listX, listY, mouseX, mouseY, delta);
        C_3754158.m_2374887((int)515);
        C_3754158.m_7027522();
        C_3754158.m_9671730();
        C_3754158.m_2693884((C_3754158.C_0114419)C_3754158.C_0114419.f_1752625, (C_3754158.C_0226345)C_3754158.C_0226345.f_9515699, (C_3754158.C_0114419)C_3754158.C_0114419.f_8999057, (C_3754158.C_0226345)C_3754158.C_0226345.f_4318298);
        C_3754158.m_6191982();
        C_3754158.m_9665853((int)7425);
        C_3754158.m_2090124();
        bufferBuilder.m_0421390(7, C_4461663.f_8459667);
        bufferBuilder.m_3299851((double)this.f_8129586, (double)(this.f_9975269 + 4), 0.0).m_9724942(0, 0, 0, 0).m_4365807();
        bufferBuilder.m_3299851((double)this.f_7901480, (double)(this.f_9975269 + 4), 0.0).m_9724942(0, 0, 0, 0).m_4365807();
        bufferBuilder.m_3299851((double)this.f_7901480, (double)this.f_9975269, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
        bufferBuilder.m_3299851((double)this.f_8129586, (double)this.f_9975269, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
        bufferBuilder.m_3299851((double)this.f_8129586, (double)this.f_9145833, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
        bufferBuilder.m_3299851((double)this.f_7901480, (double)this.f_9145833, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
        bufferBuilder.m_3299851((double)this.f_7901480, (double)(this.f_9145833 - 4), 0.0).m_9724942(0, 0, 0, 0).m_4365807();
        bufferBuilder.m_3299851((double)this.f_8129586, (double)(this.f_9145833 - 4), 0.0).m_9724942(0, 0, 0, 0).m_4365807();
        tessellator.m_8222644();
        this.renderScrollBar(bufferBuilder, tessellator);
        C_3754158.m_7547086();
        C_3754158.m_9665853((int)7424);
        C_3754158.m_2754767();
        C_3754158.m_5313301();
    }

    protected void m_2768810(int index, int x, int y, int height, int mouseX, int mouseY, float tickDelta) {
        if (y >= this.f_9975269 && y + height <= this.f_9145833) {
            super.m_2768810(index, x, y, height, mouseX, mouseY, tickDelta);
        }
    }

    public void renderScrollBar(C_8373595 bufferBuilder, C_5786166 tessellator) {
        int scrollbarStartX = this.m_3021017();
        int scrollbarEndX = scrollbarStartX + 6;
        int maxScroll = this.m_6867946();
        if (maxScroll > 0) {
            int p = (int)((float)((this.f_9145833 - this.f_9975269) * (this.f_9145833 - this.f_9975269)) / (float)this.m_6867946());
            p = C_4976084.m_1109374((int)p, (int)32, (int)(this.f_9145833 - this.f_9975269 - 8));
            int q = this.m_0467656() * (this.f_9145833 - this.f_9975269 - p) / maxScroll + this.f_9975269;
            if (q < this.f_9975269) {
                q = this.f_9975269;
            }
            bufferBuilder.m_0421390(7, C_4461663.f_8459667);
            bufferBuilder.m_3299851((double)scrollbarStartX, (double)this.f_9145833, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarEndX, (double)this.f_9145833, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarEndX, (double)this.f_9975269, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarStartX, (double)this.f_9975269, 0.0).m_9724942(0, 0, 0, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarStartX, (double)(q + p), 0.0).m_9724942(128, 128, 128, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarEndX, (double)(q + p), 0.0).m_9724942(128, 128, 128, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarEndX, (double)q, 0.0).m_9724942(128, 128, 128, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarStartX, (double)q, 0.0).m_9724942(128, 128, 128, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarStartX, (double)(q + p - 1), 0.0).m_9724942(192, 192, 192, 255).m_4365807();
            bufferBuilder.m_3299851((double)(scrollbarEndX - 1), (double)(q + p - 1), 0.0).m_9724942(192, 192, 192, 255).m_4365807();
            bufferBuilder.m_3299851((double)(scrollbarEndX - 1), (double)q, 0.0).m_9724942(192, 192, 192, 255).m_4365807();
            bufferBuilder.m_3299851((double)scrollbarStartX, (double)q, 0.0).m_9724942(192, 192, 192, 255).m_4365807();
            tessellator.m_8222644();
        }
    }

    public void confirmResult(boolean result, int id) {
        if (result) {
            DescriptionEntry entry;
            List entries = this.m_6789466();
            if (id >= 0 && id < entries.size() && (entry = (DescriptionEntry)((Object)entries.get(id))) instanceof LinkEntry) {
                String link = ((LinkEntry)entry).link;
                C_0614482.m_0461844().m_5892690(link);
            }
        }
        this.f_3511485.m_6408915((C_3020744)this.parent);
    }

    private C_9550253 creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[\\s-]", "_").toLowerCase();
        return new C_1160932("modmenu.credits.role." + translationKey, new Object[0]).m_8059675((C_9550253)new C_1716360(":"));
    }

    protected class DescriptionEntry
    extends C_1630332.C_1775830<DescriptionEntry> {
        protected String text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(String text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(String text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void m_2013749(int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            int x = this.m_1873543();
            int y = this.m_2358613();
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(x + this.indent, y);
                x += 11;
            }
            DescriptionListWidget.this.textRenderer.m_1328352(this.text, (float)(x + this.indent), (float)y, 0xAAAAAA);
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(String text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(String text, String link) {
            this(text, link, 0);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (DescriptionListWidget.this.m_5752726(mouseX, mouseY)) {
                DescriptionListWidget.this.f_3511485.m_6408915((C_3020744)new C_9468736((C_3268052)DescriptionListWidget.this, this.link, this.f_0700499, false));
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(String text) {
            super(text);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (DescriptionListWidget.this.m_5752726(mouseX, mouseY)) {
                DescriptionListWidget.this.f_3511485.m_6408915((C_3020744)new MinecraftCredits());
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        class MinecraftCredits
        extends C_2594473 {
            public MinecraftCredits() {
                super(false, () -> {});
            }
        }
    }
}

