/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0614482;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4399780;

public class ParentEntry
extends ModListEntry {
    private static final C_0561170 PARENT_MOD_TEXTURE = new C_0561170("modmenu", "textures/gui/parent_mod.png");
    protected List<Mod> children;
    protected ModListWidget list;
    protected boolean hoveringIcon = false;

    public ParentEntry(Mod parent, List<Mod> children, ModListWidget list) {
        super(parent, list);
        this.children = children;
        this.list = list;
    }

    @Override
    public void m_2013749(int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.m_2013749(rowWidth, rowHeight, mouseX, mouseY, isSelected, delta);
        int x = this.m_1873543();
        int y = this.m_2358613();
        C_4399780 font = this.client.f_0426313;
        int childrenBadgeHeight = font.f_9212522;
        int childrenBadgeWidth = font.f_9212522;
        int shownChildren = ModSearch.search(this.list.getParent(), this.list.getParent().getSearchInput(), this.getChildren()).size();
        C_1716360 str = shownChildren == this.children.size() ? new C_1716360(String.valueOf(shownChildren)) : new C_1716360(shownChildren + "/" + this.children.size());
        int childrenWidth = font.m_5191771(str.m_2400023()) - 1;
        if (childrenBadgeWidth < childrenWidth + 4) {
            childrenBadgeWidth = childrenWidth + 4;
        }
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        int childrenBadgeX = x + iconSize - childrenBadgeWidth;
        int childrenBadgeY = y + iconSize - childrenBadgeHeight;
        int childrenOutlineColor = -15698860;
        int childrenFillColor = -16172759;
        C_2691939.m_7865719((int)(childrenBadgeX + 1), (int)childrenBadgeY, (int)(childrenBadgeX + childrenBadgeWidth - 1), (int)(childrenBadgeY + 1), (int)childrenOutlineColor);
        C_2691939.m_7865719((int)childrenBadgeX, (int)(childrenBadgeY + 1), (int)(childrenBadgeX + 1), (int)(childrenBadgeY + childrenBadgeHeight - 1), (int)childrenOutlineColor);
        C_2691939.m_7865719((int)(childrenBadgeX + childrenBadgeWidth - 1), (int)(childrenBadgeY + 1), (int)(childrenBadgeX + childrenBadgeWidth), (int)(childrenBadgeY + childrenBadgeHeight - 1), (int)childrenOutlineColor);
        C_2691939.m_7865719((int)(childrenBadgeX + 1), (int)(childrenBadgeY + 1), (int)(childrenBadgeX + childrenBadgeWidth - 1), (int)(childrenBadgeY + childrenBadgeHeight - 1), (int)childrenFillColor);
        C_2691939.m_7865719((int)(childrenBadgeX + 1), (int)(childrenBadgeY + childrenBadgeHeight - 1), (int)(childrenBadgeX + childrenBadgeWidth - 1), (int)(childrenBadgeY + childrenBadgeHeight), (int)childrenOutlineColor);
        font.m_8287709(str.m_2400023(), (float)((int)((float)childrenBadgeX + (float)childrenBadgeWidth / 2.0f - (float)childrenWidth / 2.0f)), (float)(childrenBadgeY + 1), 0xCACACA);
        boolean bl = this.hoveringIcon = mouseX >= x - 1 && mouseX <= x - 1 + iconSize && mouseY >= y - 1 && mouseY <= y - 1 + iconSize;
        if (this.isMouseOver(mouseX, mouseY)) {
            C_2691939.m_7865719((int)x, (int)y, (int)(x + iconSize), (int)(y + iconSize), (int)-1601138544);
            int xOffset = this.list.getParent().showModChildren.contains(this.getMod().getId()) ? iconSize : 0;
            int yOffset = this.hoveringIcon ? iconSize : 0;
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.client.m_1218956().m_5325521(PARENT_MOD_TEXTURE);
            C_2691939.m_5935491((int)x, (int)y, (float)xOffset, (float)yOffset, (int)(iconSize + xOffset), (int)(iconSize + yOffset), (float)(ModMenuConfig.COMPACT_LIST.getValue() ? 152.0f : 256.0f), (float)(ModMenuConfig.COMPACT_LIST.getValue() ? 152.0f : 256.0f));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int i) {
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        boolean quickConfigure = ModMenuConfig.QUICK_CONFIGURE.getValue();
        if (mouseX - (double)this.list.getRowLeft() <= (double)iconSize) {
            this.toggleChildren();
            return true;
        }
        if (!quickConfigure && C_0614482.m_6698467() - this.sinceLastClick < 250L) {
            this.toggleChildren();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, i);
    }

    private void toggleChildren() {
        String id = this.getMod().getId();
        if (this.list.getParent().showModChildren.contains(id)) {
            this.list.getParent().showModChildren.remove(id);
        } else {
            this.list.getParent().showModChildren.add(id);
        }
        this.list.filter(this.list.getParent().getSearchInput(), false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        String modId = this.getMod().getId();
        if (keyCode == 257 || keyCode == 32) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
            } else {
                this.list.getParent().showModChildren.add(modId);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        if (keyCode == 263) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
                this.list.filter(this.list.getParent().getSearchInput(), false);
            }
            return true;
        }
        if (keyCode == 262) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                return this.list.keyPressed(264, 0, 0);
            }
            this.list.getParent().showModChildren.add(modId);
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void setChildren(List<Mod> children) {
        this.children = children;
    }

    public void addChildren(List<Mod> children) {
        this.children.addAll(children);
    }

    public void addChildren(Mod ... children) {
        this.children.addAll(Arrays.asList(children));
    }

    public List<Mod> getChildren() {
        return this.children;
    }

    public boolean isMouseOver(double double_1, double double_2) {
        return Objects.equals((Object)this.list.getEntryAtPos(double_1, double_2), (Object)this);
    }
}

