/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod.fabric;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.unmapped.C_3779718;
import net.minecraft.unmapped.C_7131921;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricIconHandler
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu | FabricIconHandler");
    private final Map<Path, C_3779718> modIconCache = new HashMap<Path, C_3779718>();

    public C_3779718 createIcon(ModContainer iconSource, String iconPath) {
        C_3779718 c_3779718;
        block13: {
            Path path = iconSource.getPath(iconPath);
            C_3779718 cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                C_7131921 image = C_7131921.m_4644474((InputStream)Objects.requireNonNull(inputStream));
                Validate.validState((image.m_6121053() == image.m_0291324() ? 1 : 0) != 0, (String)"Must be square icon", (Object[])new Object[0]);
                C_3779718 tex = new C_3779718(image);
                this.cacheModIcon(path, tex);
                c_3779718 = tex;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("Must be square icon")) {
                        LOGGER.error("Mod icon must be a square for icon source {}: {}", (Object)iconSource.getMetadata().getId(), (Object)iconPath, (Object)e);
                    }
                    return null;
                }
                catch (Throwable t) {
                    if (!iconPath.equals("assets/" + iconSource.getMetadata().getId() + "/icon.png")) {
                        LOGGER.error("Invalid mod icon for icon source {}: {}", (Object)iconSource.getMetadata().getId(), (Object)iconPath, (Object)t);
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return c_3779718;
    }

    @Override
    public void close() {
        for (C_3779718 tex : this.modIconCache.values()) {
            tex.close();
        }
    }

    C_3779718 getCachedModIcon(Path path) {
        return this.modIconCache.get(path);
    }

    void cacheModIcon(Path path, C_3779718 tex) {
        this.modIconCache.put(path, tex);
    }
}

