/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config.option;

import com.terraformersmc.modmenu.config.option.ConfigOption;
import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.util.TranslationUtil;
import java.util.Locale;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_9550253;

public class EnumConfigOption<E extends Enum<E>>
implements ConfigOption {
    private final String key;
    private final String translationKey;
    private final Class<E> enumClass;
    private final E defaultValue;

    public EnumConfigOption(String key, E defaultValue) {
        ConfigOptionStorage.setEnum(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public E getValue() {
        return ConfigOptionStorage.getEnum(this.key, this.enumClass);
    }

    public void setValue(E value) {
        ConfigOptionStorage.setEnum(this.key, value);
    }

    public void cycleValue() {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass);
    }

    public void cycleValue(int amount) {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass, amount);
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }

    private static <E extends Enum<E>> C_9550253 getValueText(EnumConfigOption<E> option, E value) {
        return new C_1160932(option.translationKey + "." + value.name().toLowerCase(Locale.ROOT), new Object[0]);
    }

    @Override
    public String getValueLabel() {
        return TranslationUtil.translateOptionLabel((C_9550253)new C_1160932(this.translationKey, new Object[0]), EnumConfigOption.getValueText(this, this.getValue()));
    }

    @Override
    public void click() {
        this.cycleValue();
    }
}

