/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui;

import com.google.common.base.Joiner;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.gui.widget.DescriptionListWidget;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.TexturedButtonWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.ScreenUtil;
import com.terraformersmc.modmenu.util.TranslationUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.unmapped.C_0464265;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1160932;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_2925725;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3268052;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_5585855;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9468736;
import net.minecraft.unmapped.C_9550253;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModsScreen
extends C_3020744
implements C_0464265.C_4076580 {
    private static final C_0561170 FILTERS_BUTTON_LOCATION = new C_0561170("modmenu", "textures/gui/filters_button.png");
    private static final C_0561170 CONFIGURE_BUTTON_LOCATION = new C_0561170("modmenu", "textures/gui/configure_button.png");
    private static final int SEARCH_BOX = 0;
    private static final int DESCRIPTION_LIST = 1;
    private static final int WEBSITE = 2;
    private static final int ISSUES = 3;
    private static final int FILTERS = 4;
    private static final int SORTING = 5;
    private static final int LIBRARIES = 6;
    private static final int MODS_FOLDER = 7;
    private static final int DONE = 8;
    private static final C_9550253 TOGGLE_FILTER_OPTIONS = new C_1160932("modmenu.toggleFilterOptions", new Object[0]);
    private static final C_9550253 CONFIGURE = new C_1160932("modmenu.configure", new Object[0]);
    private static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu | ModsScreen");
    private C_2925725 searchBox;
    private DescriptionListWidget descriptionListWidget;
    private final C_9550253 title;
    private final C_3020744 previousScreen;
    private ModListWidget modList;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private float scrollPercent = 0.0f;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private static final int RIGHT_PANE_Y = 48;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    private int mouseX;
    private int mouseY;
    private List<String> tooltip;
    public final Map<String, Boolean> modHasConfigScreen = new HashMap<String, Boolean>();
    public final Map<String, Throwable> modScreenErrors = new HashMap<String, Throwable>();

    public ModsScreen(C_3020744 previousScreen) {
        this.title = new C_1160932("modmenu.title", new Object[0]);
        this.previousScreen = previousScreen;
    }

    public void m_6270650(int id, boolean value) {
    }

    public void m_9497436(int id, float value) {
    }

    public void m_2101455(int id, String value) {
        this.modList.filter(value, false);
    }

    public void m_3356138() {
        super.m_3356138();
        if (this.modList.isMouseInList(this.mouseX, this.mouseY)) {
            this.modList.m_1002325();
        } else if (this.descriptionListWidget.isMouseInList(this.mouseX, this.mouseY)) {
            this.descriptionListWidget.m_1002325();
        }
    }

    public void m_2450377() {
        this.searchBox.m_0296611();
    }

    public void m_3593494() {
        this.paneY = ModMenuConfig.CONFIG_MODE.getValue() ? 48 : 67;
        this.paneWidth = this.f_5465691 / 2 - 8;
        this.rightPaneX = this.f_5465691 - this.paneWidth;
        int filtersButtonSize = ModMenuConfig.CONFIG_MODE.getValue() ? 0 : 22;
        int searchWidthMax = this.paneWidth - 32 - filtersButtonSize;
        int searchBoxWidth = ModMenuConfig.CONFIG_MODE.getValue() ? Math.min(200, searchWidthMax) : searchWidthMax;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
        this.searchBox = new C_2925725(0, this.f_2020658, this.searchBoxX, 22, searchBoxWidth, 20);
        this.searchBox.m_3101858((C_0464265.C_4076580)this);
        for (Mod mod : ModMenu.MODS.values()) {
            String id = mod.getId();
            if (this.modHasConfigScreen.containsKey(id)) continue;
            try {
                C_3020744 configScreen = ModMenu.getConfigScreen(id, this);
                this.modHasConfigScreen.put(id, configScreen != null);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warn("The '" + id + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
                this.modScreenErrors.put(id, e);
                this.modHasConfigScreen.put(id, false);
            }
            catch (Throwable e) {
                LOGGER.error("Error from mod '" + id + "'", e);
                this.modScreenErrors.put(id, e);
                this.modHasConfigScreen.put(id, false);
            }
        }
        this.modList = new ModListWidget(this.f_7153641, this.paneWidth, this.f_3080061, this.paneY, this.f_3080061 - 36, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.searchBox.m_4862541(), this.modList, this);
        this.modList.m_3867153(0);
        this.modList.reloadFilters();
        this.descriptionListWidget = new DescriptionListWidget(this.f_7153641, this.paneWidth, this.f_3080061, 108, this.f_3080061 - 36, this.f_2020658.f_6725889 + 1, this);
        this.descriptionListWidget.m_3867153(this.rightPaneX);
        TexturedButtonWidget configureButton = new TexturedButtonWidget(1, this.f_5465691 - 24, 48, 20, 20, 0, 0, 20, CONFIGURE_BUTTON_LOCATION, 32, 64){
            private C_9550253 tooltip;

            @Override
            public void m_5350167(C_8105098 minecraft, int mouseX, int mouseY) {
                String modId = ModsScreen.this.selected.getMod().getId();
                if (ModsScreen.this.selected != null) {
                    this.f_3831222 = ModsScreen.this.modHasConfigScreen.get(modId);
                } else {
                    this.f_3831222 = false;
                    this.f_1990467 = false;
                }
                boolean bl = this.f_1990467 = ModsScreen.this.selected != null && ModsScreen.this.modHasConfigScreen.get(modId) != false || ModsScreen.this.modScreenErrors.containsKey(modId);
                if (ModsScreen.this.modScreenErrors.containsKey(modId)) {
                    Throwable e = ModsScreen.this.modScreenErrors.get(modId);
                    this.tooltip = new C_1160932("modmenu.configure.error", new Object[]{modId, modId}).m_5859385().m_1643573("\n\n").m_1643573(e.toString()).m_7551367(new C_6237110().m_0282611(C_1945050.f_9213701));
                } else {
                    this.tooltip = CONFIGURE;
                }
                super.m_5350167(minecraft, mouseX, mouseY);
            }

            public void m_2016731(int mouseX, int mouseY) {
                ModsScreen.this.m_5774293(this.tooltip.m_2117196(), mouseX, mouseY);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        C_2348249 websiteButton = new C_2348249(2, this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, 84, Math.min(urlButtonWidths, 200), 20, C_3390001.m_2053009((String)"modmenu.website", (Object[])new Object[0])){

            public void m_5350167(C_8105098 minecraft, int mouseX, int mouseY) {
                this.f_1990467 = ModsScreen.this.selected != null;
                this.f_3831222 = this.f_1990467 && ModsScreen.this.selected.getMod().getWebsite() != null;
                super.m_5350167(minecraft, mouseX, mouseY);
            }
        };
        C_2348249 issuesButton = new C_2348249(3, this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, 84, Math.min(urlButtonWidths, 200), 20, C_3390001.m_2053009((String)"modmenu.issues", (Object[])new Object[0])){

            public void m_5350167(C_8105098 minecraft, int mouseX, int mouseY) {
                this.f_1990467 = ModsScreen.this.selected != null;
                this.f_3831222 = this.f_1990467 && ModsScreen.this.selected.getMod().getIssueTracker() != null;
                super.m_5350167(minecraft, mouseX, mouseY);
            }
        };
        TexturedButtonWidget filtersButton = new TexturedButtonWidget(4, this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, 20, FILTERS_BUTTON_LOCATION, 32, 64){

            public void m_2016731(int mouseX, int mouseY) {
                ModsScreen.this.m_5774293(TOGGLE_FILTER_OPTIONS.m_2117196(), mouseX, mouseY);
            }
        };
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            this.m_1572243(filtersButton);
        }
        String showLibrariesText = ModMenuConfig.SHOW_LIBRARIES.getValueLabel();
        String sortingText = ModMenuConfig.SORTING.getValueLabel();
        int showLibrariesWidth = this.f_2020658.m_0040387(showLibrariesText) + 20;
        int sortingWidth = this.f_2020658.m_0040387(sortingText) + 20;
        this.filtersWidth = showLibrariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        this.m_1572243(new C_2348249(5, this.filtersX, 45, sortingWidth, 20, sortingText){

            public void m_5350167(C_8105098 minecraft, int mouseX, int mouseY) {
                this.f_1990467 = ModsScreen.this.filterOptionsShown;
                this.f_4865617 = ModMenuConfig.SORTING.getValueLabel();
                super.m_5350167(minecraft, mouseX, mouseY);
            }
        });
        this.m_1572243(new C_2348249(6, this.filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText){

            public void m_5350167(C_8105098 minecraft, int mouseX, int mouseY) {
                this.f_1990467 = ModsScreen.this.filterOptionsShown;
                this.f_4865617 = ModMenuConfig.SHOW_LIBRARIES.getValueLabel();
                super.m_5350167(minecraft, mouseX, mouseY);
            }
        });
        if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
            this.m_1572243(configureButton);
        }
        this.m_1572243(websiteButton);
        this.m_1572243(issuesButton);
        this.m_1572243(new C_2348249(7, this.f_5465691 / 2 - 154, this.f_3080061 - 28, 150, 20, C_3390001.m_2053009((String)"modmenu.modsFolder", (Object[])new Object[0])));
        this.m_1572243(new C_2348249(8, this.f_5465691 / 2 + 4, this.f_3080061 - 28, 150, 20, C_3390001.m_2053009((String)"gui.done", (Object[])new Object[0])));
        this.searchBox.m_2785860(true);
        this.init = true;
    }

    public void m_7971793(C_2348249 button) {
        switch (button.f_5920996) {
            case 1: {
                String id = Objects.requireNonNull(this.selected).getMod().getId();
                if (this.modHasConfigScreen.get(id).booleanValue()) {
                    C_3020744 configScreen = ModMenu.getConfigScreen(id, this);
                    this.f_7153641.m_6408915(configScreen);
                    break;
                }
                button.f_3831222 = false;
                break;
            }
            case 2: {
                Mod mod = Objects.requireNonNull(this.selected).getMod();
                this.f_7153641.m_6408915((C_3020744)new C_9468736((C_3268052)this, mod.getWebsite(), 2, false));
                break;
            }
            case 3: {
                Mod mod = Objects.requireNonNull(this.selected).getMod();
                this.f_7153641.m_6408915((C_3020744)new C_9468736((C_3268052)this, mod.getIssueTracker(), 3, false));
                break;
            }
            case 4: {
                this.filterOptionsShown = !this.filterOptionsShown;
                break;
            }
            case 5: {
                ModMenuConfig.SORTING.cycleValue();
                ModMenuConfigManager.save();
                this.modList.reloadFilters();
                break;
            }
            case 6: {
                ModMenuConfig.SHOW_LIBRARIES.toggleValue();
                ModMenuConfigManager.save();
                this.modList.reloadFilters();
                break;
            }
            case 7: {
                C_5585855.m_9434190((File)new File(FabricLoader.getInstance().getGameDir().toFile(), "mods"));
                break;
            }
            case 8: {
                this.f_7153641.m_6408915(this.previousScreen);
            }
        }
    }

    public void m_6992336(char chr, int key) {
        this.searchBox.m_1973329(chr, key);
        super.m_6992336(chr, key);
    }

    public void m_7362766(int mouseX, int mouseY, int button) {
        if (this.modList.isMouseInList(mouseX, mouseY)) {
            this.modList.m_7379893(mouseX, mouseY, button);
        }
        if (this.descriptionListWidget.isMouseInList(mouseX, mouseY)) {
            this.descriptionListWidget.m_7379893(mouseX, mouseY, button);
        }
        super.m_7362766(mouseX, mouseY, button);
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tooltip = null;
        this.m_0157418(0);
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.m_9734698(mouseX, mouseY, delta);
        }
        this.modList.m_9734698(mouseX, mouseY, delta);
        this.searchBox.m_1620442();
        C_3754158.m_5313301();
        this.m_2717572(this.f_2020658, this.title.m_2117196(), this.modList.getWidth() / 2, 8, 0xFFFFFF);
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            C_9550253 fullModCount = this.computeModCountText(true);
            if (!ModMenuConfig.CONFIG_MODE.getValue() && this.updateFiltersX()) {
                if (this.filterOptionsShown) {
                    if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.f_2020658.m_0040387(fullModCount.m_2117196()) <= this.filtersX - 5) {
                        this.f_2020658.m_4683674(fullModCount.m_2117196(), this.searchBoxX, 52, 0xFFFFFF);
                    } else {
                        this.f_2020658.m_4683674(this.computeModCountText(false).m_2117196(), this.searchBoxX, 46, 0xFFFFFF);
                        this.f_2020658.m_4683674(this.computeLibraryCountText().m_2117196(), this.searchBoxX, 57, 0xFFFFFF);
                    }
                } else if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.f_2020658.m_0040387(fullModCount.m_2117196()) <= this.modList.getWidth() - 5) {
                    this.f_2020658.m_4683674(fullModCount.m_2117196(), this.searchBoxX, 52, 0xFFFFFF);
                } else {
                    this.f_2020658.m_4683674(this.computeModCountText(false).m_2117196(), this.searchBoxX, 46, 0xFFFFFF);
                    this.f_2020658.m_4683674(this.computeLibraryCountText().m_2117196(), this.searchBoxX, 57, 0xFFFFFF);
                }
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            C_1716360 name;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, x, 48, 32, 32);
            }
            C_3754158.m_3323122((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            C_3754158.m_9671730();
            this.f_7153641.m_1218956().m_5325521(this.selected.getIconTexture());
            C_2691939.m_5935491((int)x, (int)48, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
            C_3754158.m_5313301();
            int lineSpacing = this.f_2020658.f_6725889 + 1;
            int imageOffset = 36;
            C_1716360 trimmedName = name = new C_1716360(mod.getTranslatedName());
            int maxNameWidth = this.f_5465691 - (x + imageOffset);
            if (this.f_2020658.m_0040387(name.m_2117196()) > maxNameWidth) {
                C_1716360 ellipsis = new C_1716360("...");
                trimmedName = new C_1716360("").m_1643573(this.f_2020658.m_3198719(name.m_2117196(), maxNameWidth - this.f_2020658.m_0040387(ellipsis.m_2117196()))).m_8059675((C_9550253)ellipsis);
            }
            this.f_2020658.m_4683674(trimmedName.m_2117196(), x + imageOffset, 49, 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > 49 && mouseY < 49 + this.f_2020658.f_6725889 && mouseX < x + imageOffset + this.f_2020658.m_0040387(trimmedName.m_2117196())) {
                this.setTooltip(Arrays.asList(C_3390001.m_2053009((String)"modmenu.modIdToolTip", (Object[])new Object[]{mod.getId()})));
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.f_7153641.f_0426313.m_0040387(trimmedName.m_2117196()) + 2, 48, this.f_5465691 - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!ModMenuConfig.HIDE_BADGES.getValue()) {
                this.modBadgeRenderer.draw(mouseX, mouseY);
            }
            if (mod.isReal()) {
                this.f_2020658.m_4683674(mod.getPrefixedVersion(), x + imageOffset, 50 + lineSpacing, 0x808080);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.get(0);
                DrawingUtil.drawWrappedString(C_3390001.m_2053009((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, 50 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
        super.m_7261014(mouseX, mouseY, delta);
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            this.m_9128141(this.tooltip, mouseX, mouseY);
        }
    }

    private C_9550253 computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
        if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private C_9550253 computeLibraryCountText() {
        if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return new C_1716360(null);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    public float getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(float scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.m_4862541();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.f_2020658.m_0040387(this.computeModCountText(true).m_2117196()) + 20 >= this.searchRowWidth && (this.filtersWidth + this.f_2020658.m_0040387(this.computeModCountText(false).m_2117196()) + 20 >= this.searchRowWidth || this.filtersWidth + this.f_2020658.m_0040387(this.computeLibraryCountText().m_2117196()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    private static boolean isFabricMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("fabric.mod.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public Map<String, Boolean> getModHasConfigScreen() {
        return this.modHasConfigScreen;
    }

    public void m_7743236(boolean result, int id) {
        super.m_7743236(result, id);
        if (result && this.selected != null) {
            switch (id) {
                case 2: {
                    ScreenUtil.openLink(this, this.selected.mod.getWebsite(), this.selected.mod.getId() + " /website");
                    break;
                }
                case 3: {
                    ScreenUtil.openLink(this, this.selected.mod.getIssueTracker(), this.selected.mod.getId() + "/issues");
                }
            }
        }
        this.f_7153641.m_6408915((C_3020744)this);
    }
}

