/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.entries.ChildEntry;
import com.terraformersmc.modmenu.gui.widget.entries.IndependentEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import com.terraformersmc.modmenu.util.mod.fabric.FabricIconHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;

public class ModListWidget
extends C_1630332
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final ModsScreen parent;
    private final List<ModListEntry> entries = new ArrayList<ModListEntry>();
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private boolean scrolling;
    private final FabricIconHandler iconHandler = new FabricIconHandler();
    private ModListEntry selected;

    public ModListWidget(C_8105098 client, int width, int height, int y1, int y2, int entryHeight, String searchTerm, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y1, y2, entryHeight);
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
        }
        this.filter(searchTerm, false);
        this.f_1867063 = parent.getScrollPercent() * (float)Math.max(0, this.m_6867946() - (this.f_9145833 - this.f_9975269 - 4));
        this.m_7189774();
    }

    public void m_9909453(int amount) {
        super.m_9909453(amount);
        int denominator = Math.max(0, this.m_6867946() - (this.f_9145833 - this.f_9975269 - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0f);
        } else {
            this.parent.updateScrollPercent(this.m_0467656() / Math.max(0, this.m_6867946() - (this.f_9145833 - this.f_9975269 - 4)));
        }
    }

    public boolean isMouseInList(int mouseX, int mouseY) {
        return mouseY >= this.f_9975269 && mouseY <= this.f_9145833 && mouseX >= this.f_8129586 && mouseX <= this.f_7901480;
    }

    protected boolean isFocused() {
        return false;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
    }

    public void setSelected(ModListEntry entry) {
        this.selected = entry;
        this.selectedModId = entry.getMod().getId();
        this.parent.updateSelectedEntry(entry);
    }

    protected boolean m_5993229(int index) {
        return this.selected != null && this.selected.getMod().getId().equals(this.entries.get(index).getMod().getId());
    }

    public void addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return;
        }
        this.addedMods.add(entry.mod);
        this.entries.add(entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
    }

    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        return this.entries.remove(entry);
    }

    protected ModListEntry remove(int index) {
        this.addedMods.remove(this.entries.get((int)index).mod);
        return this.entries.remove(index);
    }

    public int m_3791031() {
        return this.entries.size();
    }

    public ModListEntry getEntry(int index) {
        return this.entries.get(index);
    }

    public void clear() {
        this.entries.clear();
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = !ModMenuConfig.SHOW_LIBRARIES.getValue();
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains((Object)Mod.Badge.LIBRARY));
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.clear();
        this.addedMods.clear();
        ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
            Map<String, Boolean> modHasConfigScreen;
            Boolean hasConfig;
            if (ModMenuConfig.CONFIG_MODE.getValue() && !(hasConfig = (modHasConfigScreen = this.parent.getModHasConfigScreen()).get(mod.getId())).booleanValue()) {
                return false;
            }
            return !mod.isHidden();
        }).collect(Collectors.toSet()));
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.mods == null || refresh) {
            this.mods = new ArrayList<Mod>();
            this.mods.addAll(mods);
            this.mods.sort(ModMenuConfig.SORTING.getValue().getComparator());
        }
        List<Mod> matched = ModSearch.search(this.parent, searchTerm, this.mods);
        for (Mod mod2 : matched) {
            String modId = mod2.getId();
            if (mod2.getBadges().contains((Object)Mod.Badge.LIBRARY) && !ModMenuConfig.SHOW_LIBRARIES.getValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                List children = ModMenu.PARENT_MAP.get((Object)mod2);
                children.sort(ModMenuConfig.SORTING.getValue().getComparator());
                ParentEntry parent = new ParentEntry(mod2, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                for (Mod child : validChildren) {
                    this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(mod2, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.entries.isEmpty() || this.selected != null && this.selected.getMod() != this.parent.getSelectedEntry().getMod()) {
            for (ModListEntry entry : this.entries) {
                if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                this.setSelected(entry);
            }
        } else if (this.selected == null && !this.entries.isEmpty() && this.entries.get(0) != null) {
            this.setSelected(this.entries.get(0));
        }
        if (this.m_0467656() > Math.max(0, this.m_6867946() - (this.f_9145833 - this.f_9975269 - 4))) {
            this.m_9909453(Math.max(0, this.m_6867946() - (this.f_9145833 - this.f_9975269 - 4)));
        }
    }

    protected void m_2972483(int x, int y, int mouseX, int mouseY) {
        int entryCount = this.m_3791031();
        C_5786166 tessellator = C_5786166.m_2065116();
        C_8373595 buffer = tessellator.m_1454391();
        for (int index = 0; index < entryCount; ++index) {
            int entryTop = this.getRowTop(index);
            int entryBottom = this.getRowTop(index) + this.f_5546437;
            if (entryBottom < this.f_9975269 || entryTop > this.f_9145833) continue;
            int entryHeight = this.f_5546437 - 4;
            ModListEntry entry = this.entries.get(index);
            int rowWidth = this.m_6519286();
            if (this.m_5993229(index)) {
                int entryLeft = this.getRowLeft() - 2 + entry.getXOffset();
                int selectionRight = this.getRowLeft() + rowWidth + 2;
                float float_2 = this.isFocused() ? 1.0f : 0.5f;
                C_3754158.m_2090124();
                C_3754158.m_3323122((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                buffer.m_0421390(7, C_4461663.f_6859334);
                buffer.m_3299851((double)entryLeft, (double)(entryTop + entryHeight + 2), 0.0).m_4365807();
                buffer.m_3299851((double)selectionRight, (double)(entryTop + entryHeight + 2), 0.0).m_4365807();
                buffer.m_3299851((double)selectionRight, (double)(entryTop - 2), 0.0).m_4365807();
                buffer.m_3299851((double)entryLeft, (double)(entryTop - 2), 0.0).m_4365807();
                tessellator.m_8222644();
                C_3754158.m_3323122((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.m_0421390(7, C_4461663.f_6859334);
                buffer.m_3299851((double)(entryLeft + 1), (double)(entryTop + entryHeight + 1), 0.0).m_4365807();
                buffer.m_3299851((double)(selectionRight - 1), (double)(entryTop + entryHeight + 1), 0.0).m_4365807();
                buffer.m_3299851((double)(selectionRight - 1), (double)(entryTop - 1), 0.0).m_4365807();
                buffer.m_3299851((double)(entryLeft + 1), (double)(entryTop - 1), 0.0).m_4365807();
                tessellator.m_8222644();
                C_3754158.m_7547086();
            }
            this.m_2768810(index, this.getRowLeft(), entryTop, entryHeight, mouseX, mouseY);
        }
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double)this.m_3021017() && double_1 < (double)(this.m_3021017() + 6);
    }

    public boolean m_7379893(int double_1, int double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.isMouseInList(double_1, double_2)) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(double_1, double_2);
        if (entry != null) {
            if (entry.m_3739705(this.entries.indexOf(entry), double_1, double_2, int_1, double_1, double_2)) {
                this.select(entry);
                return true;
            }
        } else if (int_1 == 0) {
            this.m_6715763((int)((double)double_1 - (double)(this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2)), (int)((double)double_2 - (double)this.f_9975269) + this.m_0467656() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean keyPressed(char chr, int key) {
        if (this.selected != null) {
            int index = this.entries.indexOf(this.selected);
            if (key == 200) {
                if (--index < 0) {
                    index = this.m_3791031() - 1;
                }
                this.select(this.entries.get(index));
                return true;
            }
            if (key == 208) {
                if (++index >= this.m_3791031()) {
                    index = 0;
                }
                this.select(this.entries.get(index));
                return true;
            }
            return this.selected.keyPressed(chr, key);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = C_4976084.m_8723286((double)(y - (double)this.f_9975269)) - this.f_2682396 + this.m_0467656() - 4;
        int index = int_5 / this.f_5546437;
        return x < (double)this.m_3021017() && x >= (double)this.getRowLeft() && x <= (double)(this.getRowLeft() + this.m_6519286()) && index >= 0 && int_5 >= 0 && index < this.m_3791031() ? this.entries.get(index) : null;
    }

    protected int m_3021017() {
        return this.f_2695432 - 6;
    }

    public int m_6519286() {
        return this.f_2695432 - (Math.max(0, this.m_6867946() - (this.f_9145833 - this.f_9975269 - 4)) > 0 ? 18 : 12);
    }

    public int getRowLeft() {
        return this.f_8129586 + 6;
    }

    public int getRowTop(int index) {
        return this.f_9975269 + 4 - this.m_0467656() + index * this.f_5546437 + this.f_2682396;
    }

    public int getWidth() {
        return this.f_2695432;
    }

    public int getTop() {
        return this.f_9975269;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    public int m_6867946() {
        return super.m_6867946() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.entries) {
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
    }

    public FabricIconHandler getFabricIconHandler() {
        return this.iconHandler;
    }
}

