/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config;

import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.config.option.BooleanConfigOption;
import com.terraformersmc.modmenu.config.option.ConfigOption;
import com.terraformersmc.modmenu.config.option.EnumConfigOption;
import com.terraformersmc.modmenu.config.option.StringSetConfigOption;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;

public class ModMenuConfig {
    public static final EnumConfigOption<Sorting> SORTING = new EnumConfigOption<Sorting>("sorting", Sorting.ASCENDING);
    public static final BooleanConfigOption COUNT_LIBRARIES = new BooleanConfigOption("count_libraries", true);
    public static final BooleanConfigOption COMPACT_LIST = new BooleanConfigOption("compact_list", false);
    public static final BooleanConfigOption COUNT_CHILDREN = new BooleanConfigOption("count_children", true);
    public static final EnumConfigOption<TitleMenuButtonStyle> MODS_BUTTON_STYLE = new EnumConfigOption<TitleMenuButtonStyle>("mods_button_style", TitleMenuButtonStyle.CLASSIC);
    public static final EnumConfigOption<GameMenuButtonStyle> GAME_MENU_BUTTON_STYLE = new EnumConfigOption<GameMenuButtonStyle>("game_menu_button_style", GameMenuButtonStyle.BELOW_ACHIEVEMENTS_AND_STATISTICS);
    public static final BooleanConfigOption COUNT_HIDDEN_MODS = new BooleanConfigOption("count_hidden_mods", true);
    public static final EnumConfigOption<ModCountLocation> MOD_COUNT_LOCATION = new EnumConfigOption<ModCountLocation>("mod_count_location", ModCountLocation.TITLE_SCREEN);
    public static final BooleanConfigOption HIDE_MOD_LINKS = new BooleanConfigOption("hide_mod_links", false);
    public static final BooleanConfigOption SHOW_LIBRARIES = new BooleanConfigOption("show_libraries", false);
    public static final BooleanConfigOption HIDE_MOD_LICENSE = new BooleanConfigOption("hide_mod_license", false);
    public static final BooleanConfigOption HIDE_BADGES = new BooleanConfigOption("hide_badges", false);
    public static final BooleanConfigOption HIDE_MOD_CREDITS = new BooleanConfigOption("hide_mod_credits", false);
    public static final BooleanConfigOption EASTER_EGGS = new BooleanConfigOption("easter_eggs", true);
    public static final BooleanConfigOption MODIFY_TITLE_SCREEN = new BooleanConfigOption("modify_title_screen", true);
    public static final BooleanConfigOption MODIFY_GAME_MENU = new BooleanConfigOption("modify_game_menu", true);
    public static final BooleanConfigOption HIDE_CONFIG_BUTTONS = new BooleanConfigOption("hide_config_buttons", false);
    public static final BooleanConfigOption RANDOM_JAVA_COLORS = new BooleanConfigOption("random_java_colors", false);
    public static final BooleanConfigOption TRANSLATE_NAMES = new BooleanConfigOption("translate_names", true);
    public static final BooleanConfigOption TRANSLATE_DESCRIPTIONS = new BooleanConfigOption("translate_descriptions", true);
    public static final BooleanConfigOption CONFIG_MODE = new BooleanConfigOption("config_mode", false);
    public static final StringSetConfigOption HIDDEN_MODS = new StringSetConfigOption("hidden_mods", new HashSet<String>());
    public static final StringSetConfigOption HIDDEN_CONFIGS = new StringSetConfigOption("hidden_configs", new HashSet<String>());
    public static final StringSetConfigOption DISABLE_UPDATE_CHECKER = new StringSetConfigOption("disable_update_checker", new HashSet<String>());
    public static final BooleanConfigOption UPDATE_CHECKER = new BooleanConfigOption("update_checker", true);
    public static final BooleanConfigOption BUTTON_UPDATE_BADGE = new BooleanConfigOption("button_update_badge", true);
    public static final EnumConfigOption<UpdateChannel> UPDATE_CHANNEL = new EnumConfigOption<UpdateChannel>("update_channel", UpdateChannel.RELEASE);
    public static final BooleanConfigOption QUICK_CONFIGURE = new BooleanConfigOption("quick_configure", true);

    public static ConfigOption[] asOptions() {
        ArrayList<ConfigOption> options = new ArrayList<ConfigOption>();
        for (Field field : ModMenuConfig.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !ConfigOption.class.isAssignableFrom(field.getType()) || field.getName().equals("HIDE_CONFIG_BUTTONS") || field.getName().equals("MODIFY_TITLE_SCREEN") || field.getName().equals("MODIFY_GAME_MENU") || field.getName().equals("CONFIG_MODE") || field.getName().equals("DISABLE_DRAG_AND_DROP")) continue;
            try {
                options.add((ConfigOption)field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return (ConfigOption[])options.stream().toArray(ConfigOption[]::new);
    }

    public static enum Sorting {
        ASCENDING(Comparator.comparing(mod -> mod.getTranslatedName().toLowerCase(Locale.ROOT))),
        DESCENDING(ASCENDING.getComparator().reversed());

        Comparator<Mod> comparator;

        private Sorting(Comparator<Mod> comparator) {
            this.comparator = comparator;
        }

        public Comparator<Mod> getComparator() {
            return this.comparator;
        }
    }

    public static enum TitleMenuButtonStyle {
        CLASSIC,
        SHRINK,
        ICON;

    }

    public static enum GameMenuButtonStyle {
        BELOW_ACHIEVEMENTS,
        BELOW_STATISTICS,
        BELOW_ACHIEVEMENTS_AND_STATISTICS,
        ICON;

    }

    public static enum ModCountLocation {
        TITLE_SCREEN(true, false),
        MODS_BUTTON(false, true),
        TITLE_SCREEN_AND_MODS_BUTTON(true, true),
        NONE(false, false);

        private final boolean titleScreen;
        private final boolean modsButton;

        private ModCountLocation(boolean titleScreen, boolean modsButton) {
            this.titleScreen = titleScreen;
            this.modsButton = modsButton;
        }

        public boolean isOnTitleScreen() {
            return this.titleScreen;
        }

        public boolean isOnModsButton() {
            return this.modsButton;
        }
    }
}

