/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.config.option;

import com.terraformersmc.modmenu.config.option.ConfigOption;
import com.terraformersmc.modmenu.config.option.ConfigOptionStorage;
import com.terraformersmc.modmenu.util.TranslationUtil;
import java.util.Locale;
import net.minecraft.unmapped.C_3390001;

public class EnumConfigOption<E extends Enum<E>>
implements ConfigOption {
    private final String key;
    private final String translationKey;
    private final Class<E> enumClass;
    private final E defaultValue;

    public EnumConfigOption(String key, E defaultValue) {
        ConfigOptionStorage.setEnum(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public E getValue() {
        return ConfigOptionStorage.getEnum(this.key, this.enumClass);
    }

    public void setValue(E value) {
        ConfigOptionStorage.setEnum(this.key, value);
    }

    public void cycleValue() {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass);
    }

    public void cycleValue(int amount) {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass, amount);
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }

    private static <E extends Enum<E>> String getValueText(EnumConfigOption<E> option, E value) {
        return C_3390001.m_4637372((String)(option.translationKey + "." + value.name().toLowerCase(Locale.ROOT)));
    }

    @Override
    public String getValueLabel() {
        return TranslationUtil.translateOptionLabel(C_3390001.m_4637372((String)this.translationKey), EnumConfigOption.getValueText(this, this.getValue()));
    }

    @Override
    public void click() {
        this.cycleValue();
    }
}

