/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.config.option.ConfigOption;
import com.terraformersmc.modmenu.gui.widget.entries.EntryListWidget;
import com.terraformersmc.modmenu.mixin.AccessorButtonWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_6682111;
import org.jetbrains.annotations.Nullable;

public class ConfigOptionListWidget
extends EntryListWidget {
    private final Minecraft minecraft;
    private final List<Entry> entries = new ArrayList<Entry>();
    private int nextId;

    public ConfigOptionListWidget(Minecraft minecraft, int width, int height, int yStart, int yEnd, int entryHeight, ConfigOption ... options) {
        super(minecraft, width, height, yStart, yEnd, entryHeight);
        this.minecraft = minecraft;
        for (int i = 0; i < options.length; i += 2) {
            ConfigOption option = options[i];
            ConfigOption option2 = i < options.length - 1 ? options[i + 1] : null;
            this.entries.add(new Entry(width, option, option2));
        }
    }

    @Nullable
    private static C_2348249 createWidget(Minecraft minecraft, int id, int x, int y, int width, @Nullable ConfigOption option) {
        if (option == null) {
            return null;
        }
        C_6682111 button = new C_6682111(id, x, y, null, option.getValueLabel());
        ((AccessorButtonWidget)button).setWidth(width);
        return button;
    }

    @Override
    public Entry getEntry(int i) {
        return this.entries.get(i);
    }

    protected int m_3791031() {
        return this.entries.size();
    }

    @Override
    public int getRowWidth() {
        return 400;
    }

    @Override
    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    public boolean isMouseInList(int mouseX, int mouseY) {
        return mouseY >= this.f_9975269 && mouseY <= this.f_9145833 && mouseX >= this.f_8129586 && mouseX <= this.f_7901480;
    }

    public final class Entry
    implements EntryListWidget.Entry {
        @Nullable
        private final ConfigOption leftOption;
        @Nullable
        private final C_2348249 left;
        @Nullable
        private final ConfigOption rightOption;
        @Nullable
        private final C_2348249 right;

        public Entry(@Nullable C_2348249 left, ConfigOption leftOption, @Nullable C_2348249 right, ConfigOption rightOption) {
            this.left = left;
            this.leftOption = leftOption;
            this.right = right;
            this.rightOption = rightOption;
        }

        public Entry(int x, ConfigOption option) {
            this(ConfigOptionListWidget.createWidget(this$0.minecraft, this$0.nextId++, x / 2 - 155, 0, 310, option), option, null, null);
        }

        public Entry(@Nullable int x, ConfigOption option, ConfigOption option2) {
            this(ConfigOptionListWidget.createWidget(this$0.minecraft, this$0.nextId++, x / 2 - 155, 0, 150, option), option, ConfigOptionListWidget.createWidget(this$0.minecraft, this$0.nextId++, x / 2 - 155 + 160, 0, 150, option2), option2);
        }

        @Override
        public void render(int index, int x, int y, int width, int height, C_5786166 bufferBuilder, int mouseX, int mouseY, boolean hovered) {
            if (this.left != null) {
                this.left.f_8532347 = y;
                this.left.m_5350167(ConfigOptionListWidget.this.minecraft, mouseX, mouseY);
            }
            if (this.right != null) {
                this.right.f_8532347 = y;
                this.right.m_5350167(ConfigOptionListWidget.this.minecraft, mouseX, mouseY);
            }
        }

        @Override
        public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            if (button == 0) {
                if (this.left != null && this.left.m_9491400(ConfigOptionListWidget.this.minecraft, mouseX, mouseY)) {
                    this.leftOption.click();
                    ((ConfigOptionListWidget)ConfigOptionListWidget.this).minecraft.f_3843367.m_7271958("random.click", 1.0f, 1.0f);
                    this.left.f_4865617 = this.leftOption.getValueLabel();
                    return true;
                }
                if (this.right != null && this.right.m_9491400(ConfigOptionListWidget.this.minecraft, mouseX, mouseY)) {
                    this.rightOption.click();
                    ((ConfigOptionListWidget)ConfigOptionListWidget.this).minecraft.f_3843367.m_7271958("random.click", 1.0f, 1.0f);
                    this.right.f_4865617 = this.rightOption.getValueLabel();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void mouseReleased(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            this.left.m_4418537(mouseX, mouseY);
            this.right.m_4418537(mouseX, mouseY);
        }
    }
}

