/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ConfirmChatLinkScreen;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.EntryListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.GlUtil;
import com.terraformersmc.modmenu.util.MathUtil;
import com.terraformersmc.modmenu.util.ScreenUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_5786166;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class DescriptionListWidget
extends EntryListWidget {
    private static final String HAS_UPDATE_TEXT = C_3390001.m_4637372((String)"modmenu.hasUpdate");
    private static final String EXPERIMENTAL_TEXT = C_3390001.m_4637372((String)"modmenu.experimental");
    private static final String DOWNLOAD_TEXT = "" + C_3390001.m_4637372((String)"modmenu.downloadLink");
    private static final String CHILD_HAS_UPDATE_TEXT = C_3390001.m_4637372((String)"modmenu.childHasUpdate");
    private static final String LINKS_TEXT = C_3390001.m_4637372((String)"modmenu.links");
    private static final String SOURCE_TEXT = "" + C_3390001.m_4637372((String)"modmenu.source");
    private static final String LICENSE_TEXT = C_3390001.m_4637372((String)"modmenu.license");
    private static final String VIEW_CREDITS_TEXT = "" + C_3390001.m_4637372((String)"modmenu.viewCredits");
    private static final String CREDITS_TEXT = C_3390001.m_4637372((String)"modmenu.credits");
    private final Minecraft minecraft;
    private final ModsScreen parent;
    private final C_3831727 textRenderer;
    private final List<DescriptionEntry> entries = new ArrayList<DescriptionEntry>();
    private ModListEntry lastSelected = null;

    public DescriptionListWidget(Minecraft client, int width, int height, int top, int bottom, int entryHeight, ModsScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.minecraft = client;
        this.parent = parent;
        this.textRenderer = client.f_0426313;
    }

    @Override
    public int getRowWidth() {
        return this.f_2695432 - 10;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.f_2695432 - 6 + this.f_8129586;
    }

    public boolean isMouseInList(int mouseX, int mouseY) {
        return mouseY >= this.f_9975269 && mouseY <= this.f_9145833 && mouseX >= this.f_8129586 && mouseX <= this.f_7901480;
    }

    public int m_3791031() {
        return this.entries.size();
    }

    public void clear() {
        this.entries.clear();
    }

    @Override
    public DescriptionEntry getEntry(int index) {
        return this.entries.get(index);
    }

    @Override
    public void m_9734698(int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.m_7189774();
        ModListEntry selectedEntry = this.parent.getSelectedEntry();
        if (selectedEntry != this.lastSelected) {
            this.lastSelected = selectedEntry;
            this.clear();
            if (this.lastSelected != null) {
                DescriptionEntry emptyEntry = new DescriptionEntry("");
                int wrapWidth = this.getRowWidth() - 5;
                Mod mod = this.lastSelected.getMod();
                String description = mod.getTranslatedDescription();
                if (!description.isEmpty()) {
                    for (Object line : this.textRenderer.split(description.replaceAll("\n", "\n\n"), wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)line));
                    }
                }
                if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(mod.getId())) {
                    UpdateInfo updateInfo = mod.getUpdateInfo();
                    if (updateInfo != null && updateInfo.isUpdateAvailable()) {
                        this.entries.add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.split(HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            DescriptionEntry descriptionEntry = new DescriptionEntry((String)line);
                            if (index == 0) {
                                descriptionEntry.setUpdateTextEntry();
                            }
                            this.entries.add(descriptionEntry);
                            ++index;
                        }
                        for (Object line : this.textRenderer.split(EXPERIMENTAL_TEXT, wrapWidth - 16)) {
                            this.entries.add(new DescriptionEntry((String)line, 8));
                        }
                        Object updateMessage = updateInfo.getUpdateMessage();
                        String downloadLink = updateInfo.getDownloadLink();
                        if (updateMessage == null) {
                            updateMessage = DOWNLOAD_TEXT;
                        } else if (downloadLink != null) {
                            updateMessage = "" + (String)updateMessage;
                        }
                        for (Object line : this.textRenderer.split((String)updateMessage, wrapWidth - 16)) {
                            if (downloadLink != null) {
                                this.entries.add(new LinkEntry((String)line, downloadLink, 8));
                                continue;
                            }
                            this.entries.add(new DescriptionEntry((String)line, 8));
                        }
                    }
                    if (mod.getChildHasUpdate()) {
                        this.entries.add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.split(CHILD_HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            DescriptionEntry descriptionEntry = new DescriptionEntry((String)line);
                            if (index == 0) {
                                descriptionEntry.setUpdateTextEntry();
                            }
                            this.entries.add(descriptionEntry);
                            ++index;
                        }
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                    this.entries.add(emptyEntry);
                    for (Object line : this.textRenderer.split(LINKS_TEXT, wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object e : this.textRenderer.split(SOURCE_TEXT, wrapWidth - 16)) {
                            this.entries.add(new LinkEntry((String)e, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (Object line : this.textRenderer.split("" + C_3390001.m_4637372((String)key), wrapWidth - 16)) {
                            this.entries.add(new LinkEntry((String)line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    this.entries.add(emptyEntry);
                    for (Object e : this.textRenderer.split(LICENSE_TEXT, wrapWidth)) {
                        this.entries.add(new DescriptionEntry((String)e));
                    }
                    for (String string : licenses) {
                        int indent = 8;
                        for (Object line : this.textRenderer.split(string, wrapWidth - 16)) {
                            this.entries.add(new DescriptionEntry((String)line, indent));
                            indent = 16;
                        }
                    }
                }
                if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
                    SortedMap<String, Set<String>> credits;
                    if ("minecraft".equals(mod.getId())) {
                        this.entries.add(emptyEntry);
                    } else if (!"java".equals(mod.getId()) && !(credits = mod.getCredits()).isEmpty()) {
                        this.entries.add(emptyEntry);
                        for (Object line : this.textRenderer.split(CREDITS_TEXT, wrapWidth)) {
                            this.entries.add(new DescriptionEntry((String)line));
                        }
                        Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
                        while (iterator.hasNext()) {
                            int indent = 8;
                            Map.Entry<String, Set<String>> role = iterator.next();
                            String roleName = role.getKey();
                            for (Object line : this.textRenderer.split(this.creditsRoleText(roleName), wrapWidth - 16)) {
                                this.entries.add(new DescriptionEntry((String)line, indent));
                                indent = 16;
                            }
                            for (String contributor : role.getValue()) {
                                indent = 16;
                                for (Object line : this.textRenderer.split(contributor, wrapWidth - 24)) {
                                    this.entries.add(new DescriptionEntry((String)line, indent));
                                    indent = 24;
                                }
                            }
                            if (!iterator.hasNext()) continue;
                            this.entries.add(emptyEntry);
                        }
                    }
                }
            }
        }
        C_5786166 bufferBuilder = C_5786166.f_7436514;
        this.minecraft.f_9413506.m_1620317(this.minecraft.f_9413506.m_9688911("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.m_0346438(7);
        bufferBuilder.m_8773546(32, 32, 32);
        bufferBuilder.m_1165938((double)this.f_8129586, (double)this.f_9145833, 0.0, (double)((float)this.f_8129586 / 32.0f), ((double)this.f_9145833 + this.scrollAmount) / 32.0);
        bufferBuilder.m_1165938((double)this.f_7901480, (double)this.f_9145833, 0.0, (double)((float)this.f_7901480 / 32.0f), ((double)this.f_9145833 + this.scrollAmount) / 32.0);
        bufferBuilder.m_1165938((double)this.f_7901480, (double)this.f_9975269, 0.0, (double)((float)this.f_7901480 / 32.0f), ((double)this.f_9975269 + this.scrollAmount) / 32.0);
        bufferBuilder.m_1165938((double)this.f_8129586, (double)this.f_9975269, 0.0, (double)((float)this.f_8129586 / 32.0f), ((double)this.f_9975269 + this.scrollAmount) / 32.0);
        bufferBuilder.m_7459300();
        int listX = this.f_8129586 + this.f_2695432 / 2 - this.getRowWidth() / 2 + 2;
        int listY = this.f_9975269 + 4 - (int)this.scrollAmount;
        this.renderList(listX, listY, mouseX, mouseY);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GlUtil.blendFuncSeparate(770, 771, 0, 1);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        bufferBuilder.m_0346438(7);
        bufferBuilder.m_7869387(0, 0, 0, 0);
        bufferBuilder.m_1165938((double)this.f_8129586, (double)(this.f_9975269 + 4), 0.0, 0.0, 1.0);
        bufferBuilder.m_1165938((double)this.f_7901480, (double)(this.f_9975269 + 4), 0.0, 1.0, 1.0);
        bufferBuilder.m_7869387(0, 0, 0, 255);
        bufferBuilder.m_1165938((double)this.f_7901480, (double)this.f_9975269, 0.0, 1.0, 0.0);
        bufferBuilder.m_1165938((double)this.f_8129586, (double)this.f_9975269, 0.0, 0.0, 0.0);
        bufferBuilder.m_7459300();
        bufferBuilder.m_0346438(7);
        bufferBuilder.m_7869387(0, 0, 0, 255);
        bufferBuilder.m_1165938((double)this.f_8129586, (double)this.f_9145833, 0.0, 0.0, 1.0);
        bufferBuilder.m_1165938((double)this.f_7901480, (double)this.f_9145833, 0.0, 1.0, 1.0);
        bufferBuilder.m_7869387(0, 0, 0, 0);
        bufferBuilder.m_1165938((double)this.f_7901480, (double)(this.f_9145833 - 4), 0.0, 1.0, 0.0);
        bufferBuilder.m_1165938((double)this.f_8129586, (double)(this.f_9145833 - 4), 0.0, 0.0, 0.0);
        bufferBuilder.m_7459300();
        this.renderScrollBar(bufferBuilder);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public void handleMouse() {
        int size = this.m_3791031();
        int scrollbarMinX = this.getScrollbarPosition();
        int scrollbarMaxX = scrollbarMinX + 6;
        if (this.mouseX > this.f_8129586 && this.mouseX < this.f_7901480 && this.mouseY > this.f_9975269 && this.mouseY < this.f_9145833) {
            if (Mouse.isButtonDown((int)0)) {
                if (this.f_9208105 == -1.0f) {
                    boolean mouseClickMode = true;
                    if (this.mouseY >= this.f_9975269 && this.mouseY <= this.f_9145833) {
                        int rowMinX = this.f_2695432 / 2 - this.getRowWidth() / 2;
                        int rowMaxX = this.f_2695432 / 2 + this.getRowWidth() / 2;
                        int selectedY = this.mouseY - this.f_9975269 - this.f_2682396 + (int)this.scrollAmount - 4;
                        int selectedPos = selectedY / this.f_5546437;
                        if (this.mouseX >= rowMinX && this.mouseX <= rowMaxX && selectedPos >= 0 && selectedY >= 0 && selectedPos < size) {
                            boolean selectedIndex = selectedPos == this.f_2556808 && MathUtil.getTime() - this.f_2629217 < 250L;
                            this.m_0479322(selectedPos, selectedIndex);
                            this.f_2556808 = selectedPos;
                            this.f_2629217 = MathUtil.getTime();
                        } else if (this.mouseX >= rowMinX && this.mouseX <= rowMaxX && selectedY < 0) {
                            this.m_6715763(this.mouseX - rowMinX, this.mouseY - this.f_9975269 + (int)this.scrollAmount - 4);
                            mouseClickMode = false;
                        }
                        if (this.mouseX >= scrollbarMinX && this.mouseX <= scrollbarMaxX) {
                            int heightForScrolling;
                            this.f_0138282 = -1.0f;
                            int maxScroll = this.getMaxScroll();
                            if (maxScroll < 1) {
                                maxScroll = 1;
                            }
                            if ((heightForScrolling = (int)((float)((this.f_9145833 - this.f_9975269) * (this.f_9145833 - this.f_9975269)) / (float)this.m_2038715())) < 32) {
                                heightForScrolling = 32;
                            }
                            if (heightForScrolling > this.f_9145833 - this.f_9975269 - 8) {
                                heightForScrolling = this.f_9145833 - this.f_9975269 - 8;
                            }
                            this.f_0138282 /= (float)(this.f_9145833 - this.f_9975269 - heightForScrolling) / (float)maxScroll;
                        } else {
                            this.f_0138282 = 1.0f;
                        }
                        this.f_9208105 = mouseClickMode ? (float)this.mouseY : -2.0f;
                    } else {
                        this.f_9208105 = -2.0f;
                    }
                } else if (this.f_9208105 >= 0.0f) {
                    this.scrollAmount -= (double)(((float)this.mouseY - this.f_9208105) * this.f_0138282);
                    this.f_9208105 = this.mouseY;
                }
            } else {
                int dwheel = Mouse.getEventDWheel();
                if (dwheel != 0) {
                    dwheel = dwheel > 0 ? -1 : 1;
                    this.scrollAmount += (double)(dwheel * this.f_5546437);
                }
                this.f_9208105 = -1.0f;
            }
        }
        this.m_7189774();
    }

    @Override
    protected void m_2768810(int index, int x, int y, int height, C_5786166 bufferBuilder) {
        if (y >= this.f_9975269 && y + height <= this.f_9145833) {
            super.m_2768810(index, x, y, height, bufferBuilder);
        }
    }

    public void renderScrollBar(C_5786166 bufferBuilder) {
        int scrollbarStartX = this.getScrollbarPosition();
        int scrollbarEndX = scrollbarStartX + 6;
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int p = (int)((float)((this.f_9145833 - this.f_9975269) * (this.f_9145833 - this.f_9975269)) / (float)this.getMaxScroll());
            p = MathUtil.clamp(p, 32, this.f_9145833 - this.f_9975269 - 8);
            int q = this.getScrollAmount() * (this.f_9145833 - this.f_9975269 - p) / maxScroll + this.f_9975269;
            if (q < this.f_9975269) {
                q = this.f_9975269;
            }
            bufferBuilder.m_0346438(7);
            bufferBuilder.m_7869387(0, 0, 0, 255);
            bufferBuilder.m_1165938((double)scrollbarStartX, (double)this.f_9145833, 0.0, 0.0, 1.0);
            bufferBuilder.m_1165938((double)scrollbarEndX, (double)this.f_9145833, 0.0, 1.0, 1.0);
            bufferBuilder.m_1165938((double)scrollbarEndX, (double)this.f_9975269, 0.0, 1.0, 0.0);
            bufferBuilder.m_1165938((double)scrollbarStartX, (double)this.f_9975269, 0.0, 0.0, 0.0);
            bufferBuilder.m_7459300();
            bufferBuilder.m_0346438(7);
            bufferBuilder.m_7869387(128, 128, 128, 255);
            bufferBuilder.m_1165938((double)scrollbarStartX, (double)(q + p), 0.0, 0.0, 1.0);
            bufferBuilder.m_1165938((double)scrollbarEndX, (double)(q + p), 0.0, 1.0, 1.0);
            bufferBuilder.m_1165938((double)scrollbarEndX, (double)q, 0.0, 1.0, 0.0);
            bufferBuilder.m_1165938((double)scrollbarStartX, (double)q, 0.0, 0.0, 0.0);
            bufferBuilder.m_7459300();
            bufferBuilder.m_0346438(7);
            bufferBuilder.m_7869387(192, 192, 192, 255);
            bufferBuilder.m_1165938((double)scrollbarStartX, (double)(q + p - 1), 0.0, 0.0, 1.0);
            bufferBuilder.m_1165938((double)(scrollbarEndX - 1), (double)(q + p - 1), 0.0, 1.0, 1.0);
            bufferBuilder.m_1165938((double)(scrollbarEndX - 1), (double)q, 0.0, 1.0, 0.0);
            bufferBuilder.m_1165938((double)scrollbarStartX, (double)q, 0.0, 0.0, 0.0);
            bufferBuilder.m_7459300();
        }
    }

    public void confirmResult(boolean result, int id) {
        if (result) {
            DescriptionEntry entry;
            int index = id - 10;
            List<DescriptionEntry> entries = this.entries;
            if (index >= 0 && index < entries.size() && (entry = entries.get(index)) instanceof LinkEntry) {
                String link = ((LinkEntry)entry).link;
                ScreenUtil.openLink(this.parent, link, this.parent.getSelectedEntry().mod.getId() + "/link");
            }
        }
        this.minecraft.m_6408915((C_3020744)this.parent);
    }

    private String creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[\\s-]", "_").toLowerCase();
        return C_3390001.m_4637372((String)("modmenu.credits.role." + translationKey)) + ":";
    }

    protected class DescriptionEntry
    implements EntryListWidget.Entry {
        protected String text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(String text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(String text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        @Override
        public void render(int index, int x, int y, int width, int height, C_5786166 bufferBuilder, int mouseX, int mouseY, boolean hovered) {
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(x + this.indent, y);
                x += 11;
            }
            DescriptionListWidget.this.textRenderer.m_1950885(this.text, x + this.indent, y, 0xAAAAAA);
        }

        @Override
        public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            return false;
        }

        @Override
        public void mouseReleased(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(String text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(String text, String link) {
            this(text, link, 0);
        }

        @Override
        public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
            if (DescriptionListWidget.this.isMouseInList(mouseX, mouseY)) {
                DescriptionListWidget.this.minecraft.m_6408915((C_3020744)new ConfirmChatLinkScreen(DescriptionListWidget.this.parent, this.link, 10 + index){

                    @Override
                    public void copy() {
                    }
                });
            }
            return super.mouseClicked(index, mouseX, mouseY, button, entryMouseX, entryMouseY);
        }
    }
}

