/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.EntryListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.mixin.AccessorMinecraft;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.MathUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_5786166;
import org.lwjgl.opengl.GL11;

public class ModListEntry
extends C_2691939
implements EntryListWidget.Entry {
    public static final String UNKNOWN_ICON = "/gui/unknown_pack.png";
    private static final String MOD_CONFIGURATION_ICON = "/assets/modmenu/textures/gui/mod_configuration.png";
    private static final String ERROR_ICON = "/gui/trap.png";
    protected final Minecraft client;
    public final Mod mod;
    protected final ModListWidget list;
    protected Integer iconGlId;
    protected static final int FULL_ICON_SIZE = 32;
    protected static final int COMPACT_ICON_SIZE = 19;
    protected long sinceLastClick;

    public ModListEntry(Mod mod, ModListWidget list) {
        this.mod = mod;
        this.list = list;
        this.client = AccessorMinecraft.getInstance();
    }

    @Override
    public void render(int index, int x, int y, int rowWidth, int rowHeight, C_5786166 bufferBuilder, int mouseX, int mouseY, boolean hovered) {
        String name;
        x += this.getXOffset();
        rowWidth -= this.getXOffset();
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        String modId = this.mod.getId();
        if ("java".equals(modId)) {
            DrawingUtil.drawRandomVersionBackground(this.mod, x, y, iconSize, iconSize);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        this.bindIconTexture();
        DrawingUtil.drawTexture(x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        GL11.glDisable((int)3042);
        String trimmedName = name = this.mod.getTranslatedName();
        int maxNameWidth = rowWidth - iconSize - 3;
        C_3831727 font = this.client.f_0426313;
        if (font.m_0040387(name) > maxNameWidth) {
            String ellipsis = "...";
            trimmedName = font.trim(name, maxNameWidth - font.m_0040387(ellipsis)) + ellipsis;
        }
        font.m_4683674(trimmedName, x + iconSize + 3, y + 1, 0xFFFFFF);
        int updateBadgeXOffset = 0;
        if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(modId) && (this.mod.hasUpdate() || this.mod.getChildHasUpdate())) {
            UpdateAvailableBadge.renderBadge(x + iconSize + 3 + font.m_0040387(name) + 2, y);
            updateBadgeXOffset = 11;
        }
        if (!ModMenuConfig.HIDE_BADGES.getValue()) {
            new ModBadgeRenderer(x + iconSize + 3 + font.m_0040387(name) + 2 + updateBadgeXOffset, y, x + rowWidth, this.mod, this.list.getParent()).draw(mouseX, mouseY);
        }
        if (!ModMenuConfig.COMPACT_LIST.getValue()) {
            String summary = this.mod.getSummary();
            DrawingUtil.drawWrappedString(summary, x + iconSize + 3 + 4, y + 8 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        } else {
            DrawingUtil.drawWrappedString(this.mod.getPrefixedVersion(), x + iconSize + 3, y + 8 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        }
        if (!(this instanceof ParentEntry) && ModMenuConfig.QUICK_CONFIGURE.getValue() && (this.list.getParent().getModHasConfigScreen().get(modId).booleanValue() || this.list.getParent().modScreenErrors.containsKey(modId))) {
            int textureSize;
            int n = textureSize = ModMenuConfig.COMPACT_LIST.getValue() ? 152 : 256;
            if (hovered) {
                int v;
                this.m_7865719(x, y, x + iconSize, y + iconSize, -1601138544);
                boolean hoveringIcon = mouseX - x < iconSize;
                int n2 = v = hoveringIcon ? iconSize : 0;
                if (this.list.getParent().modScreenErrors.containsKey(modId)) {
                    this.client.f_9413506.m_1620317(this.client.f_9413506.m_9688911(ERROR_ICON));
                    DrawingUtil.drawTexture(x, y, 96.0f, v, iconSize, iconSize, textureSize, textureSize);
                    if (hoveringIcon) {
                        Throwable e = this.list.getParent().modScreenErrors.get(modId);
                        this.list.getParent().setTooltip(this.client.f_0426313.split(C_3390001.m_2053009((String)"modmenu.configure.error", (Object[])new Object[]{modId, modId}) + "\n\n" + e.toString(), 175));
                    }
                } else {
                    this.client.f_9413506.m_1620317(this.client.f_9413506.m_9688911(MOD_CONFIGURATION_ICON));
                    DrawingUtil.drawTexture(x, y, 0.0f, v, iconSize, iconSize, textureSize, textureSize);
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
        this.list.select(this);
        if (ModMenuConfig.QUICK_CONFIGURE.getValue() && this.list.getParent().getModHasConfigScreen().get(this.mod.getId()).booleanValue()) {
            int iconSize;
            int n = iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
            if (mouseX - this.list.getRowLeft() <= iconSize) {
                this.openConfig();
            } else if (MathUtil.getTime() - this.sinceLastClick < 250L) {
                this.openConfig();
            }
        }
        this.sinceLastClick = MathUtil.getTime();
        return true;
    }

    @Override
    public void mouseReleased(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
    }

    public boolean keyPressed(char chr, int key) {
        return false;
    }

    public void openConfig() {
        this.client.m_6408915(ModMenu.getConfigScreen(this.mod.getId(), this.list.getParent()));
    }

    public Mod getMod() {
        return this.mod;
    }

    public void bindIconTexture() {
        if (this.iconGlId == null) {
            BufferedImage icon = this.mod.getIcon(this.list.getFabricIconHandler(), 64 * this.client.f_9967940.f_7306555);
            this.iconGlId = icon != null ? Integer.valueOf(this.client.f_9413506.m_0440500(icon)) : Integer.valueOf(this.client.f_9413506.m_9688911(UNKNOWN_ICON));
        }
        this.client.f_9413506.m_1620317(this.iconGlId.intValue());
    }

    public int getXOffset() {
        return 0;
    }
}

