/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.MathUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_5786166;
import org.lwjgl.opengl.GL11;

public class ParentEntry
extends ModListEntry {
    private static final String PARENT_MOD_TEXTURE = "/assets/modmenu/textures/gui/parent_mod.png";
    protected List<Mod> children;
    protected ModListWidget list;
    protected boolean hoveringIcon = false;

    public ParentEntry(Mod parent, List<Mod> children, ModListWidget list) {
        super(parent, list);
        this.children = children;
        this.list = list;
    }

    @Override
    public void render(int index, int x, int y, int rowWidth, int rowHeight, C_5786166 bufferBuilder, int mouseX, int mouseY, boolean hovered) {
        super.render(index, x, y, rowWidth, rowHeight, bufferBuilder, mouseX, mouseY, hovered);
        C_3831727 font = this.client.f_0426313;
        int childrenBadgeHeight = 8;
        int childrenBadgeWidth = 8;
        int shownChildren = ModSearch.search(this.list.getParent(), this.list.getParent().getSearchInput(), this.getChildren()).size();
        String str = shownChildren == this.children.size() ? String.valueOf(shownChildren) : shownChildren + "/" + this.children.size();
        int childrenWidth = font.m_0040387(str) - 1;
        if (childrenBadgeWidth < childrenWidth + 4) {
            childrenBadgeWidth = childrenWidth + 4;
        }
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        int childrenBadgeX = x + iconSize - childrenBadgeWidth;
        int childrenBadgeY = y + iconSize - childrenBadgeHeight;
        int childrenOutlineColor = -15698860;
        int childrenFillColor = -16172759;
        this.m_7865719(childrenBadgeX + 1, childrenBadgeY, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenOutlineColor);
        this.m_7865719(childrenBadgeX, childrenBadgeY + 1, childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        this.m_7865719(childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        this.m_7865719(childrenBadgeX + 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight - 1, childrenFillColor);
        this.m_7865719(childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight, childrenOutlineColor);
        font.m_4683674(str, (int)((float)childrenBadgeX + (float)childrenBadgeWidth / 2.0f - (float)childrenWidth / 2.0f), childrenBadgeY + 1, 0xCACACA);
        boolean bl = this.hoveringIcon = mouseX >= x - 1 && mouseX <= x - 1 + iconSize && mouseY >= y - 1 && mouseY <= y - 1 + iconSize;
        if (this.isMouseOver(mouseX, mouseY)) {
            this.m_7865719(x, y, x + iconSize, y + iconSize, -1601138544);
            int xOffset = this.list.getParent().showModChildren.contains(this.getMod().getId()) ? iconSize : 0;
            int yOffset = this.hoveringIcon ? iconSize : 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.client.f_9413506.m_1620317(this.client.f_9413506.m_9688911(PARENT_MOD_TEXTURE));
            DrawingUtil.drawTexture(x, y, xOffset, yOffset, iconSize + xOffset, iconSize + yOffset, ModMenuConfig.COMPACT_LIST.getValue() ? 152.0f : 256.0f, ModMenuConfig.COMPACT_LIST.getValue() ? 152.0f : 256.0f);
        }
    }

    @Override
    public boolean mouseClicked(int index, int mouseX, int mouseY, int button, int entryMouseX, int entryMouseY) {
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        boolean quickConfigure = ModMenuConfig.QUICK_CONFIGURE.getValue();
        if (mouseX - this.list.getRowLeft() <= iconSize) {
            this.toggleChildren();
            return true;
        }
        if (!quickConfigure && MathUtil.getTime() - this.sinceLastClick < 250L) {
            this.toggleChildren();
            return true;
        }
        return super.mouseClicked(index, mouseX, mouseY, button, entryMouseX, entryMouseY);
    }

    private void toggleChildren() {
        String id = this.getMod().getId();
        if (this.list.getParent().showModChildren.contains(id)) {
            this.list.getParent().showModChildren.remove(id);
        } else {
            this.list.getParent().showModChildren.add(id);
        }
        this.list.filter(this.list.getParent().getSearchInput(), false);
    }

    @Override
    public boolean keyPressed(char chr, int key) {
        String modId = this.getMod().getId();
        if (key == 28 || key == 57) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
            } else {
                this.list.getParent().showModChildren.add(modId);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        if (key == 203) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
                this.list.filter(this.list.getParent().getSearchInput(), false);
            }
            return true;
        }
        if (key == 205) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                return this.list.keyPressed('\uffff', 208);
            }
            this.list.getParent().showModChildren.add(modId);
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        return super.keyPressed(chr, key);
    }

    public void setChildren(List<Mod> children) {
        this.children = children;
    }

    public void addChildren(List<Mod> children) {
        this.children.addAll(children);
    }

    public void addChildren(Mod ... children) {
        this.children.addAll(Arrays.asList(children));
    }

    public List<Mod> getChildren() {
        return this.children;
    }

    public boolean isMouseOver(double double_1, double double_2) {
        return Objects.equals(this.list.getEntryAtPos(double_1, double_2), this);
    }
}

