/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util;

import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.mixin.AccessorMinecraft;
import com.terraformersmc.modmenu.util.MathUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_5786166;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class DrawingUtil
extends C_2691939 {
    private static final Minecraft CLIENT = AccessorMinecraft.getInstance();
    private static final DrawingUtil GUI = new DrawingUtil();
    public static final int fontHeight = 8;

    public static void drawRandomVersionBackground(Mod mod, int x, int y, int width, int height) {
        int seed = mod.getName().hashCode() + mod.getVersion().hashCode();
        Random random = new Random(seed);
        int color = 0xFF000000 | MathUtil.toRgb(MathUtil.nextFloat(random, 0.0f, 1.0f), MathUtil.nextFloat(random, 0.7f, 0.8f), 0.9f);
        if (!ModMenuConfig.RANDOM_JAVA_COLORS.getValue()) {
            color = -2271658;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GUI.m_7865719(x, y, x + width, y + height, color);
    }

    public static void drawWrappedString(String string, int x, int y, int wrapWidth, int lines, int color) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        List strings = DrawingUtil.CLIENT.f_0426313.split(string, wrapWidth);
        for (int i = 0; i < strings.size() && i < lines; ++i) {
            String renderable = (String)strings.get(i);
            if (i == lines - 1 && strings.size() > lines) {
                renderable = renderable + "...";
            }
            int x1 = x;
            DrawingUtil.CLIENT.f_0426313.m_4683674(renderable, x1, y + i * 8, color);
        }
    }

    public static void drawBadge(int x, int y, int tagWidth, String text, int outlineColor, int fillColor, int textColor) {
        GUI.m_7865719(x + 1, y - 1, x + tagWidth, y, outlineColor);
        GUI.m_7865719(x, y, x + 1, y + 8, outlineColor);
        GUI.m_7865719(x + 1, y + 1 + 8 - 1, x + tagWidth, y + 8 + 1, outlineColor);
        GUI.m_7865719(x + tagWidth, y, x + tagWidth + 1, y + 8, outlineColor);
        GUI.m_7865719(x + 1, y, x + tagWidth, y + 8, fillColor);
        DrawingUtil.CLIENT.f_0426313.m_4683674(text, (int)((float)(x + 1) + (float)(tagWidth - DrawingUtil.CLIENT.f_0426313.m_0040387(text)) / 2.0f), y + 1, textColor);
    }

    public static void drawTexture(int x, int y, float u, float v, int width, int height, float scaleU, float scaleV) {
        float invertedScaleU = 1.0f / scaleU;
        float invertedScaleV = 1.0f / scaleV;
        C_5786166 bufferBuilder = C_5786166.f_7436514;
        bufferBuilder.m_5815628();
        bufferBuilder.m_1165938((double)x, (double)(y + height), 0.0, (double)(u * invertedScaleU), (double)((v + (float)height) * invertedScaleV));
        bufferBuilder.m_1165938((double)(x + width), (double)(y + height), 0.0, (double)((u + (float)width) * invertedScaleU), (double)((v + (float)height) * invertedScaleV));
        bufferBuilder.m_1165938((double)(x + width), (double)y, 0.0, (double)((u + (float)width) * invertedScaleU), (double)(v * invertedScaleV));
        bufferBuilder.m_1165938((double)x, (double)y, 0.0, (double)(u * invertedScaleU), (double)(v * invertedScaleV));
        bufferBuilder.m_7459300();
    }
}

