/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.util.VersionUtil;
import java.io.IOException;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpUtil {
    private static final String USER_AGENT = HttpUtil.buildUserAgent();
    private static final CloseableHttpClient HTTP_CLIENT = HttpClientBuilder.create().build();

    private HttpUtil() {
    }

    public static HttpResponse request(RequestBuilder builder) throws IOException {
        builder.setHeader("User-Agent", USER_AGENT);
        return HTTP_CLIENT.execute(builder.build());
    }

    private static String buildUserAgent() {
        String env = ModMenu.devEnvironment ? "/development" : "";
        String loader = ModMenu.runningQuilt ? "quilt" : "fabric";
        String modMenuVersion = HttpUtil.getModMenuVersion("modmenu");
        String minecraftVersion = HttpUtil.getModMenuVersion("minecraft");
        return String.format("%s/%s (%s/%s%s)", "OrnitheMC/ModMenu", modMenuVersion, minecraftVersion, loader, env);
    }

    private static String getModMenuVersion(String modId) {
        Optional container = FabricLoader.getInstance().getModContainer(modId);
        if (!container.isPresent()) {
            throw new RuntimeException("Unable to find Modmenu's own mod container!");
        }
        return VersionUtil.removeBuildMetadata(((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString());
    }
}

