/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.util.HttpUtil;
import com.terraformersmc.modmenu.util.UpdateCheckerThreadFactory;
import com.terraformersmc.modmenu.util.VersionUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModrinthUpdateInfo;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class UpdateCheckerUtil {
    public static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu/Update Checker");
    private static boolean modrinthApiV2Deprecated = false;

    private static boolean allowsUpdateChecks(Mod mod) {
        return mod.allowsUpdateChecks();
    }

    public static void checkForUpdates() {
        if (!ModMenuConfig.UPDATE_CHECKER.getValue()) {
            return;
        }
        LOGGER.info("Checking mod updates...");
        CompletableFuture.runAsync(UpdateCheckerUtil::checkForUpdates0);
    }

    private static void checkForUpdates0() {
        ExecutorService executor = Executors.newCachedThreadPool(new UpdateCheckerThreadFactory());
        ArrayList<Mod> withoutUpdateChecker = new ArrayList<Mod>();
        ModMenu.MODS.values().stream().filter(UpdateCheckerUtil::allowsUpdateChecks).forEach(mod -> {
            UpdateChecker updateChecker = mod.getUpdateChecker();
            if (updateChecker == null) {
                withoutUpdateChecker.add((Mod)mod);
            } else {
                executor.submit(() -> {
                    Thread.currentThread().setName("ModMenu/Update Checker/" + mod.getName());
                    UpdateInfo update = updateChecker.checkForUpdates();
                    if (update == null) {
                        return;
                    }
                    mod.setUpdateInfo(update);
                    LOGGER.info("Update available for '{}@{}'", (Object)mod.getId(), (Object)mod.getVersion());
                });
            }
        });
        if (modrinthApiV2Deprecated) {
            return;
        }
        Map<String, Set<Mod>> modHashes = UpdateCheckerUtil.getModHashes(withoutUpdateChecker);
        Future<Map> currentVersionsFuture = executor.submit(() -> UpdateCheckerUtil.getCurrentVersions(modHashes.keySet()));
        Future<Map> updatedVersionsFuture = executor.submit(() -> UpdateCheckerUtil.getUpdatedVersions(modHashes.keySet()));
        Map currentVersions = null;
        Map updatedVersions = null;
        try {
            currentVersions = currentVersionsFuture.get();
            updatedVersions = updatedVersionsFuture.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (currentVersions == null || updatedVersions == null) {
            return;
        }
        for (String hash : modHashes.keySet()) {
            Instant date = (Instant)currentVersions.get(hash);
            VersionUpdate data = (VersionUpdate)updatedVersions.get(hash);
            if (date == null || data == null || Objects.equals(hash, data.hash) || date.compareTo(data.releaseDate) >= 0) continue;
            for (Mod mod2 : modHashes.get(hash)) {
                mod2.setUpdateInfo(data.asUpdateInfo());
                LOGGER.info("Update available for '{}@{}', (-> {})", (Object)mod2.getId(), (Object)mod2.getVersion(), (Object)data.versionNumber);
            }
        }
    }

    private static Map<String, Set<Mod>> getModHashes(Collection<Mod> mods) {
        HashMap<String, Set<Mod>> results = new HashMap<String, Set<Mod>>();
        for (Mod mod : mods) {
            String modId = mod.getId();
            try {
                String hash = mod.getSha512Hash();
                if (hash == null) continue;
                LOGGER.debug("Hash for {} is {}", (Object)modId, (Object)hash);
                results.putIfAbsent(hash, new HashSet());
                ((Set)results.get(hash)).add(mod);
            }
            catch (IOException e) {
                LOGGER.error("Error getting mod hash for mod {}: ", (Object)modId, (Object)e);
            }
        }
        return results;
    }

    @Nullable
    private static Map<String, Instant> getCurrentVersions(Collection<String> modHashes) {
        String body = ModMenu.GSON_MINIFIED.toJson((Object)new CurrentVersionsFromHashes(modHashes));
        try {
            RequestBuilder request = RequestBuilder.post().setEntity((HttpEntity)new StringEntity(body)).addHeader("Content-Type", "application/json").setUri(URI.create("https://api.modrinth.com/v2/version_files"));
            HttpResponse response = HttpUtil.request(request);
            int status = response.getStatusLine().getStatusCode();
            if (status == 410) {
                modrinthApiV2Deprecated = true;
                LOGGER.warn("Modrinth API v2 is deprecated, unable to check for mod updates.");
            } else if (status == 200) {
                HashMap<String, Instant> results = new HashMap<String, Instant>();
                JsonObject data = new JsonParser().parse(EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject();
                data.entrySet().forEach(entry -> {
                    Instant date;
                    JsonObject version = ((JsonElement)entry.getValue()).getAsJsonObject();
                    try {
                        date = Instant.parse(version.get("date_published").getAsString());
                    }
                    catch (DateTimeParseException e) {
                        return;
                    }
                    results.put((String)entry.getKey(), date);
                });
                return results;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error checking for versions: ", (Throwable)e);
        }
        return null;
    }

    private static UpdateChannel getUpdateChannel(String versionType) {
        try {
            return UpdateChannel.valueOf(versionType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return UpdateChannel.RELEASE;
        }
    }

    @Nullable
    private static Map<String, VersionUpdate> getUpdatedVersions(Collection<String> modHashes) {
        String mcVer = VersionUtil.getModrinthCompatibleMcVersion();
        List<String> loaders = ModMenu.runningQuilt ? Arrays.asList("fabric", "quilt") : Arrays.asList("fabric");
        UpdateChannel preferredChannel = UpdateChannel.getUserPreference();
        List<UpdateChannel> updateChannels = preferredChannel == UpdateChannel.RELEASE ? Arrays.asList(UpdateChannel.RELEASE) : (preferredChannel == UpdateChannel.BETA ? Arrays.asList(UpdateChannel.BETA, UpdateChannel.RELEASE) : Arrays.asList(UpdateChannel.ALPHA, UpdateChannel.BETA, UpdateChannel.RELEASE));
        String body = ModMenu.GSON_MINIFIED.toJson((Object)new LatestVersionsFromHashesBody(modHashes, loaders, mcVer, updateChannels));
        LOGGER.debug("Body: " + body);
        try {
            RequestBuilder latestVersionsRequest = RequestBuilder.post().setEntity((HttpEntity)new StringEntity(body)).addHeader("Content-Type", "application/json").setUri(URI.create("https://api.modrinth.com/v2/version_files/update"));
            HttpResponse response = HttpUtil.request(latestVersionsRequest);
            int status = response.getStatusLine().getStatusCode();
            LOGGER.debug("Status: " + status);
            if (status == 410) {
                modrinthApiV2Deprecated = true;
                LOGGER.warn("Modrinth API v2 is deprecated, unable to check for mod updates.");
            } else if (status == 200) {
                HashMap<String, VersionUpdate> results = new HashMap<String, VersionUpdate>();
                JsonObject responseObject = new JsonParser().parse(EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject();
                LOGGER.debug(String.valueOf(responseObject));
                responseObject.entrySet().forEach(entry -> {
                    Instant date;
                    String lookupHash = (String)entry.getKey();
                    JsonObject versionObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                    String projectId = versionObj.get("project_id").getAsString();
                    String versionType = versionObj.get("version_type").getAsString();
                    String versionNumber = versionObj.get("version_number").getAsString();
                    String versionId = versionObj.get("id").getAsString();
                    ArrayList files = new ArrayList();
                    versionObj.get("files").getAsJsonArray().forEach(files::add);
                    Optional<JsonElement> primaryFile = files.stream().filter(file -> file.getAsJsonObject().get("primary").getAsBoolean()).findFirst();
                    if (!primaryFile.isPresent()) {
                        return;
                    }
                    try {
                        date = Instant.parse(versionObj.get("date_published").getAsString());
                    }
                    catch (DateTimeParseException e) {
                        return;
                    }
                    UpdateChannel updateChannel = UpdateCheckerUtil.getUpdateChannel(versionType);
                    String versionHash = primaryFile.get().getAsJsonObject().get("hashes").getAsJsonObject().get("sha512").getAsString();
                    results.put(lookupHash, new VersionUpdate(projectId, versionId, versionNumber, date, updateChannel, versionHash));
                });
                return results;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error checking for updates: ", (Throwable)e);
        }
        return null;
    }

    private static class VersionUpdate {
        String projectId;
        String versionId;
        String versionNumber;
        Instant releaseDate;
        UpdateChannel updateChannel;
        String hash;

        public VersionUpdate(String projectId, String versionId, String versionNumber, Instant releaseDate, UpdateChannel updateChannel, String has) {
            this.projectId = projectId;
            this.versionId = versionId;
            this.versionNumber = versionNumber;
            this.releaseDate = releaseDate;
            this.updateChannel = updateChannel;
            this.hash = has;
        }

        private UpdateInfo asUpdateInfo() {
            return new ModrinthUpdateInfo(this.projectId, this.versionId, this.versionNumber, this.updateChannel);
        }
    }

    public static class CurrentVersionsFromHashes {
        public Collection<String> hashes;
        public String algorithm = "sha512";

        public CurrentVersionsFromHashes(Collection<String> hashes) {
            this.hashes = hashes;
        }
    }

    public static class LatestVersionsFromHashesBody {
        public Collection<String> hashes;
        public String algorithm = "sha512";
        public Collection<String> loaders;
        @SerializedName(value="game_versions")
        public Collection<String> gameVersions;
        @SerializedName(value="version_types")
        public Collection<String> versionTypes;

        public LatestVersionsFromHashesBody(Collection<String> hashes, Collection<String> loaders, String mcVersion, Collection<UpdateChannel> updateChannels) {
            this.hashes = hashes;
            this.loaders = loaders;
            this.gameVersions = new HashSet<String>();
            this.gameVersions.add(mcVersion);
            this.versionTypes = new HashSet<String>();
            for (UpdateChannel updateChannel : updateChannels) {
                this.versionTypes.add(updateChannel.toString().toLowerCase());
            }
        }
    }
}

